/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.query;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.Util;
import org.infinispan.client.hotrod.impl.operations.QueryOperation;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.api.query.HitCount;
import org.infinispan.commons.api.query.QueryResult;
import org.infinispan.commons.query.BaseQuery;
import org.infinispan.commons.query.TotalHitCount;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.client.impl.BaseQueryResponse;

public final class RemoteQuery<T>
extends BaseQuery<T> {
    private static final Log log = LogFactory.getLog(RemoteQuery.class);
    private final InternalRemoteCache<?, ?> cache;
    private final SerializationContext serializationContext;

    RemoteQuery(InternalRemoteCache<?, ?> cache, SerializationContext serializationContext, String queryString) {
        super(queryString);
        this.cache = cache;
        this.serializationContext = serializationContext;
    }

    public void resetQuery() {
    }

    public List<T> list() {
        return this.execute().list();
    }

    public org.infinispan.query.dsl.QueryResult<T> execute() {
        return (org.infinispan.query.dsl.QueryResult)this.awaitQueryResult(this.executeAsync());
    }

    public int executeStatement() {
        return this.awaitQueryResult(this.executeStatementAsync());
    }

    public CloseableIterator<T> iterator() {
        if (this.maxResults == -1 && this.startOffset == 0) {
            log.warnPerfRemoteIterationWithoutPagination(this.queryString);
        }
        return Closeables.iterator(this.list().iterator());
    }

    public int getResultSize() {
        return this.awaitQueryResult(this.executeRemotelyAsync(true)).hitCount();
    }

    public CompletionStage<QueryResult<T>> executeAsync() {
        return this.internalExecuteAsync().thenApply(CompletableFutures.identity());
    }

    public CompletionStage<Integer> executeStatementAsync() {
        return this.executeRemotelyAsync(false).thenApply(BaseQueryResponse::hitCount);
    }

    private CompletableFuture<BaseQueryResponse<T>> executeRemotelyAsync(boolean withHitCount) {
        this.validateNamedParameters();
        QueryOperation op = this.cache.getOperationsFactory().newQueryOperation(this, withHitCount);
        CompletionStage stage = this.cache.getDispatcher().execute(op);
        return stage.toCompletableFuture();
    }

    public SerializationContext getSerializationContext() {
        return this.serializationContext;
    }

    public RemoteCache<?, ?> getCache() {
        return this.cache;
    }

    private <R> List<R> extractResults(BaseQueryResponse<R> response) {
        try {
            return response.extractResults(this.serializationContext);
        }
        catch (IOException e) {
            throw new HotRodClientException(e);
        }
    }

    private <R> R awaitQueryResult(CompletionStage<R> rsp) {
        return this.timeout == -1L ? this.cache.getDispatcher().await(rsp) : Util.await(rsp.toCompletableFuture(), this.timeout);
    }

    private CompletionStage<QueryResultAdapter<T>> internalExecuteAsync() {
        return this.executeRemotelyAsync(true).thenApply(x$0 -> new QueryResultAdapter(x$0));
    }

    public String toString() {
        return "RemoteQuery{queryString=" + this.queryString + ", namedParameters=" + String.valueOf(this.namedParameters) + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + ", timeout=" + this.timeout + "}";
    }

    private class QueryResultAdapter<R>
    implements org.infinispan.query.dsl.QueryResult<R> {
        private final BaseQueryResponse<R> queryResponse;

        QueryResultAdapter(BaseQueryResponse<R> queryResponse) {
            this.queryResponse = queryResponse;
        }

        public HitCount count() {
            return new TotalHitCount(this.queryResponse.hitCount(), this.queryResponse.hitCountExact());
        }

        public List<R> list() {
            return RemoteQuery.this.extractResults(this.queryResponse);
        }
    }
}

