/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.MetadataValueImpl;
import org.infinispan.client.hotrod.impl.iteration.KeyTracker;
import org.infinispan.client.hotrod.impl.operations.AbstractCacheOperation;
import org.infinispan.client.hotrod.impl.operations.CacheUnmarshaller;
import org.infinispan.client.hotrod.impl.operations.IterationNextResponse;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;

public class IterationNextOperation<K, E>
extends AbstractCacheOperation<IterationNextResponse<K, E>> {
    private final byte[] iterationId;
    private final KeyTracker segmentKeyTracker;
    private byte[] finishedSegments;
    private int entriesSize = -1;
    private List<Map.Entry<K, E>> entries;
    private int projectionsSize;
    private int untrackedEntries;

    protected IterationNextOperation(InternalRemoteCache<?, ?> cache, byte[] iterationId, KeyTracker segmentKeyTracker) {
        super(cache);
        this.iterationId = iterationId;
        this.segmentKeyTracker = segmentKeyTracker;
    }

    @Override
    public void writeOperationRequest(Channel channel, ByteBuf buf, Codec codec) {
        ByteBufUtil.writeArray(buf, this.iterationId);
    }

    @Override
    public IterationNextResponse<K, E> createResponse(ByteBuf buf, short status, HeaderDecoder decoder, Codec codec, CacheUnmarshaller unmarshaller) {
        if (this.entriesSize < 0) {
            this.finishedSegments = ByteBufUtil.readArray(buf);
            this.entriesSize = ByteBufUtil.readVInt(buf);
            if (this.entriesSize == 0) {
                IntSet finishedSegmentSet = IntSets.from((byte[])this.finishedSegments);
                this.segmentKeyTracker.segmentsFinished(finishedSegmentSet);
                return new IterationNextResponse(status, Collections.emptyList(), finishedSegmentSet, false);
            }
            this.entries = new ArrayList<Map.Entry<K, E>>(this.entriesSize);
            this.projectionsSize = -1;
            decoder.checkpoint();
        }
        if (this.projectionsSize < 0) {
            this.projectionsSize = ByteBufUtil.readVInt(buf);
            decoder.checkpoint();
        }
        ClassAllowList classAllowList = this.internalRemoteCache.getRemoteCacheContainer().getConfiguration().getClassAllowList();
        while (this.entries.size() + this.untrackedEntries < this.entriesSize) {
            Object value;
            short meta = buf.readUnsignedByte();
            long creation = -1L;
            int lifespan = -1;
            long lastUsed = -1L;
            int maxIdle = -1;
            long version = 0L;
            if (meta == 1) {
                short flags = buf.readUnsignedByte();
                if ((flags & 1) != 1) {
                    creation = buf.readLong();
                    lifespan = ByteBufUtil.readVInt(buf);
                }
                if ((flags & 2) != 2) {
                    lastUsed = buf.readLong();
                    maxIdle = ByteBufUtil.readVInt(buf);
                }
                version = buf.readLong();
            }
            byte[] key = ByteBufUtil.readArray(buf);
            if (this.projectionsSize > 1) {
                Object[] projections = new Object[this.projectionsSize];
                for (int j = 0; j < this.projectionsSize; ++j) {
                    projections[j] = unmarshaller.readValue(buf);
                }
                value = projections;
            } else {
                value = unmarshaller.readValue(buf);
            }
            if (meta == 1) {
                value = new MetadataValueImpl(creation, lifespan, lastUsed, maxIdle, version, value);
            }
            if (this.segmentKeyTracker.track(key, status, classAllowList)) {
                Object unmarshallKey = this.internalRemoteCache.getDataFormat().keyToObj(key, classAllowList);
                this.entries.add(new AbstractMap.SimpleEntry(unmarshallKey, value));
            } else {
                ++this.untrackedEntries;
            }
            decoder.checkpoint();
        }
        IntSet finishedSegmentSet = IntSets.from((byte[])this.finishedSegments);
        this.segmentKeyTracker.segmentsFinished(finishedSegmentSet);
        if (HotRodConstants.isInvalidIteration(status)) {
            throw Log.HOTROD.errorRetrievingNext(new String(this.iterationId, HOTROD_STRING_CHARSET));
        }
        return new IterationNextResponse<K, E>(status, this.entries, finishedSegmentSet, true);
    }

    @Override
    public short requestOpCode() {
        return 51;
    }

    @Override
    public short responseOpCode() {
        return 52;
    }

    @Override
    public boolean supportRetry() {
        return false;
    }
}

