/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.impl;

import java.util.concurrent.CompletableFuture;
import org.infinispan.client.hotrod.counter.impl.BaseCounter;
import org.infinispan.client.hotrod.counter.impl.CounterOperationFactory;
import org.infinispan.client.hotrod.counter.impl.NotificationManager;
import org.infinispan.client.hotrod.impl.transport.netty.OperationDispatcher;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.api.SyncStrongCounter;

class StrongCounterImpl
extends BaseCounter
implements StrongCounter {
    private final SyncStrongCounter syncCounter = new Sync();

    StrongCounterImpl(String name, CounterConfiguration configuration, CounterOperationFactory operationFactory, OperationDispatcher dispatcher, NotificationManager notificationManager) {
        super(configuration, name, operationFactory, dispatcher, notificationManager);
    }

    public CompletableFuture<Long> getValue() {
        return this.dispatcher.execute(this.factory.newGetValueOperation(this.name, this.useConsistentHash())).toCompletableFuture();
    }

    public CompletableFuture<Long> addAndGet(long delta) {
        return this.dispatcher.execute(this.factory.newAddOperation(this.name, delta, this.useConsistentHash())).toCompletableFuture();
    }

    public CompletableFuture<Long> compareAndSwap(long expect, long update) {
        return this.dispatcher.execute(this.factory.newCompareAndSwapOperation(this.name, expect, update, super.getConfiguration())).toCompletableFuture();
    }

    public SyncStrongCounter sync() {
        return this.syncCounter;
    }

    public CompletableFuture<Long> getAndSet(long value) {
        return this.dispatcher.execute(this.factory.newSetOperation(this.name, value, this.useConsistentHash())).toCompletableFuture();
    }

    @Override
    boolean useConsistentHash() {
        return true;
    }

    private class Sync
    implements SyncStrongCounter {
        private Sync() {
        }

        public long addAndGet(long delta) {
            return StrongCounterImpl.this.dispatcher.await(StrongCounterImpl.this.addAndGet(delta));
        }

        public void reset() {
            StrongCounterImpl.this.dispatcher.await(StrongCounterImpl.this.reset());
        }

        public long getValue() {
            return StrongCounterImpl.this.dispatcher.await(StrongCounterImpl.this.getValue());
        }

        public long compareAndSwap(long expect, long update) {
            return StrongCounterImpl.this.dispatcher.await(StrongCounterImpl.this.compareAndSwap(expect, update));
        }

        public String getName() {
            return StrongCounterImpl.this.name;
        }

        public CounterConfiguration getConfiguration() {
            return StrongCounterImpl.this.configuration;
        }

        public void remove() {
            StrongCounterImpl.this.dispatcher.await(StrongCounterImpl.this.remove());
        }

        public long getAndSet(long value) {
            return StrongCounterImpl.this.dispatcher.await(StrongCounterImpl.this.getAndSet(value));
        }
    }
}

