/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Semaphore;
import java.util.function.BiFunction;
import org.infinispan.client.hotrod.impl.transport.netty.OperationDispatcher;

public class PutOutputStream
extends OutputStream {
    private static final int BUFFER_SIZE = 8192;
    private final BiFunction<ByteBuf, Boolean, CompletionStage<Void>> consumer;
    private final ByteBufAllocator alloc;
    private final Semaphore pendingWrites = new Semaphore(2);
    private final OperationDispatcher dispatcher;
    private ByteBuf buf;
    private volatile Throwable throwable;

    public PutOutputStream(BiFunction<ByteBuf, Boolean, CompletionStage<Void>> consumer, ByteBufAllocator alloc, OperationDispatcher dispatcher) {
        this.consumer = consumer;
        this.alloc = alloc;
        this.dispatcher = dispatcher;
    }

    private void alloc() {
        this.buf = this.alloc.buffer(8192, 8192);
    }

    private void consume(ByteBuf buf, boolean complete) throws IOException {
        try {
            this.pendingWrites.acquire();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        CompletionStage<Void> stage = this.consumer.apply(buf, complete).whenComplete((___, t) -> {
            this.pendingWrites.release();
            if (t != null) {
                this.throwable = t;
            }
        });
        if (complete) {
            this.dispatcher.await(stage);
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.throwable != null) {
            throw new IOException(this.throwable);
        }
        if (this.buf == null) {
            this.alloc();
        } else if (!this.buf.isWritable()) {
            this.consume(this.buf, false);
            this.alloc();
        }
        this.buf.writeByte(b);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.throwable != null) {
            throw new IOException(this.throwable);
        }
        if (this.buf == null) {
            this.handleNullByteBufWrite(b, off, len);
            return;
        }
        int writeableAmount = this.buf.writableBytes();
        if (len > writeableAmount) {
            this.buf.writeBytes(b, off, writeableAmount);
            this.consume(this.buf, false);
            this.buf = null;
            this.handleNullByteBufWrite(b, off + writeableAmount, len - writeableAmount);
        } else {
            this.buf.writeBytes(b, off, len);
        }
    }

    private void handleNullByteBufWrite(byte[] b, int off, int len) throws IOException {
        int needToWrite;
        if (len > 8192) {
            for (needToWrite = len; needToWrite > 8192; needToWrite -= 8192) {
                this.alloc();
                this.buf.writeBytes(b, off + (len - needToWrite), 8192);
                this.consume(this.buf, false);
            }
        }
        this.alloc();
        this.buf.writeBytes(b, off + (len - needToWrite), needToWrite);
    }

    @Override
    public synchronized void flush() throws IOException {
        this.flush(false);
    }

    private void flush(boolean complete) throws IOException {
        if (this.throwable != null) {
            throw new IOException(this.throwable);
        }
        if (this.buf != null && this.buf.isReadable()) {
            ByteBuf buf = this.buf;
            this.buf = null;
            this.consume(buf, complete);
        }
    }

    @Override
    public void close() throws IOException {
        this.flush(true);
    }
}

