/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.multimap.operations;

import com.google.errorprone.annotations.Immutable;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.multimap.metadata.MetadataCollectionImpl;
import org.infinispan.client.hotrod.impl.multimap.operations.AbstractMultimapKeyOperation;
import org.infinispan.client.hotrod.impl.operations.CacheUnmarshaller;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.multimap.MetadataCollection;

@Immutable
public class GetKeyWithMetadataMultimapOperation<V>
extends AbstractMultimapKeyOperation<MetadataCollection<V>> {
    private static final Log log = LogFactory.getLog(GetKeyWithMetadataMultimapOperation.class);

    public GetKeyWithMetadataMultimapOperation(InternalRemoteCache<?, ?> remoteCache, byte[] keyBytes, boolean supportsDuplicates) {
        super(remoteCache, keyBytes, supportsDuplicates);
    }

    @Override
    public MetadataCollection<V> createResponse(ByteBuf buf, short status, HeaderDecoder decoder, Codec codec, CacheUnmarshaller unmarshaller) {
        if (HotRodConstants.isNotExist(status)) {
            return new MetadataCollectionImpl(Collections.emptySet());
        }
        if (!HotRodConstants.isSuccess(status)) {
            return null;
        }
        short flags = buf.readByte();
        long creation = -1L;
        int lifespan = -1;
        long lastUsed = -1L;
        int maxIdle = -1;
        if ((flags & 1) != 1) {
            creation = buf.readLong();
            lifespan = ByteBufUtil.readVInt(buf);
        }
        if ((flags & 2) != 2) {
            lastUsed = buf.readLong();
            maxIdle = ByteBufUtil.readVInt(buf);
        }
        long version = buf.readLong();
        if (log.isTraceEnabled()) {
            log.tracef("Received version: %d", version);
        }
        int size = ByteBufUtil.readVInt(buf);
        ArrayList values = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            Object value = unmarshaller.readValue(buf);
            values.add(value);
        }
        return new MetadataCollectionImpl(values, creation, lifespan, lastUsed, maxIdle, version);
    }

    @Override
    public short requestOpCode() {
        return 105;
    }

    @Override
    public short responseOpCode() {
        return 106;
    }
}

