/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.impl;

import java.util.concurrent.CompletableFuture;
import org.infinispan.client.hotrod.counter.impl.BaseCounter;
import org.infinispan.client.hotrod.counter.impl.CounterOperationFactory;
import org.infinispan.client.hotrod.counter.impl.NotificationManager;
import org.infinispan.client.hotrod.impl.transport.netty.OperationDispatcher;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.SyncWeakCounter;
import org.infinispan.counter.api.WeakCounter;

class WeakCounterImpl
extends BaseCounter
implements WeakCounter {
    private final SyncWeakCounter syncCounter = new Sync();

    WeakCounterImpl(String name, CounterConfiguration configuration, CounterOperationFactory operationFactory, OperationDispatcher dispatcher, NotificationManager notificationManager) {
        super(configuration, name, operationFactory, dispatcher, notificationManager);
    }

    public long getValue() {
        return this.dispatcher.await(this.dispatcher.execute(this.factory.newGetValueOperation(this.name, this.useConsistentHash())));
    }

    public CompletableFuture<Void> add(long delta) {
        return this.dispatcher.execute(this.factory.newAddOperation(this.name, delta, this.useConsistentHash())).toCompletableFuture().thenRun(() -> {});
    }

    public SyncWeakCounter sync() {
        return this.syncCounter;
    }

    private class Sync
    implements SyncWeakCounter {
        private Sync() {
        }

        public String getName() {
            return WeakCounterImpl.this.name;
        }

        public long getValue() {
            return WeakCounterImpl.this.getValue();
        }

        public void add(long delta) {
            WeakCounterImpl.this.dispatcher.await(WeakCounterImpl.this.add(delta));
        }

        public void reset() {
            WeakCounterImpl.this.dispatcher.await(WeakCounterImpl.this.reset());
        }

        public CounterConfiguration getConfiguration() {
            return WeakCounterImpl.this.configuration;
        }

        public void remove() {
            WeakCounterImpl.this.dispatcher.await(WeakCounterImpl.this.remove());
        }
    }
}

