/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transaction.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.List;
import java.util.stream.Collectors;
import javax.transaction.xa.Xid;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.operations.AbstractCacheOperation;
import org.infinispan.client.hotrod.impl.operations.CacheUnmarshaller;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transaction.entry.Modification;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

public class PrepareTransactionOperation
extends AbstractCacheOperation<Integer> {
    private final Xid xid;
    private final boolean onePhaseCommit;
    private final List<Modification> modifications;
    private final boolean recoverable;
    private final long timeoutMs;
    private boolean retry;

    public PrepareTransactionOperation(InternalRemoteCache<?, ?> cache, Xid xid, boolean onePhaseCommit, List<Modification> modifications, boolean recoverable, long timeoutMs) {
        super(cache);
        this.xid = xid;
        this.onePhaseCommit = onePhaseCommit;
        this.modifications = modifications;
        this.recoverable = recoverable;
        this.timeoutMs = timeoutMs;
    }

    public boolean shouldRetry() {
        return this.retry;
    }

    @Override
    public Integer createResponse(ByteBuf buf, short status, HeaderDecoder decoder, Codec codec, CacheUnmarshaller unmarshaller) {
        if (status == 0) {
            return buf.readInt();
        }
        this.retry = status == 1;
        return 0;
    }

    @Override
    public short requestOpCode() {
        return 125;
    }

    @Override
    public short responseOpCode() {
        return 126;
    }

    @Override
    public Object getRoutingObject() {
        return this.modifications.isEmpty() ? null : this.modifications.get(0).getKey();
    }

    @Override
    public DataFormat getDataFormat() {
        return null;
    }

    @Override
    public void writeOperationRequest(Channel channel, ByteBuf buf, Codec codec) {
        PrepareTransactionOperation.writeOperationRequest(buf, codec, this.xid, this.onePhaseCommit, this.recoverable, this.timeoutMs, this.modifications);
    }

    public static void writeOperationRequest(ByteBuf buf, Codec codec, Xid xid, boolean onePhaseCommit, boolean recoverable, long timeoutMs, List<Modification> modifications) {
        ByteBufUtil.writeXid(buf, xid);
        buf.writeBoolean(onePhaseCommit);
        buf.writeBoolean(recoverable);
        buf.writeLong(timeoutMs);
        ByteBufUtil.writeVInt(buf, modifications.size());
        for (Modification m : modifications) {
            m.writeTo(buf, codec);
        }
    }

    @Override
    protected void addParams(StringBuilder sb) {
        sb.append(", modifications=[");
        sb.append(this.modifications.stream().map(Object::toString).collect(Collectors.joining(",")).toString());
        sb.append("]");
    }
}

