/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.api.exception.InfinispanException;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteSchemasAdmin;
import org.infinispan.client.hotrod.impl.RemoteCacheManagerAdminImpl;
import org.infinispan.client.hotrod.impl.operations.ManagerOperationsFactory;
import org.infinispan.client.hotrod.impl.transport.netty.OperationDispatcher;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.schema.Schema;

public class RemoteSchemasAdminImpl
implements RemoteSchemasAdmin {
    public static final Log log = LogFactory.getLog(RemoteSchemasAdminImpl.class, Log.class);
    private final ManagerOperationsFactory operationsFactory;
    private final OperationDispatcher operationDispatcher;
    private final RemoteCache<String, String> protostreamCache;
    private static final byte[] CREATE = RemoteCacheManagerAdminImpl.string("c");
    private static final byte[] UPDATE = RemoteCacheManagerAdminImpl.string("u");
    private static final byte[] SAVE = RemoteCacheManagerAdminImpl.string("s");
    private static final byte[] FORCE = RemoteCacheManagerAdminImpl.string("f");

    protected RemoteSchemasAdminImpl(ManagerOperationsFactory operationsFactory, OperationDispatcher operationDispatcher, RemoteCacheManager cacheManager) {
        this.operationsFactory = operationsFactory;
        this.operationDispatcher = operationDispatcher;
        this.protostreamCache = cacheManager.getCache("___protobuf_metadata").withFlags(Flag.FORCE_RETURN_VALUE);
    }

    @Override
    public CompletionStage<Boolean> existsAsync(String schemaName) {
        return this.protostreamCache.containsKeyAsync(schemaName);
    }

    @Override
    public CompletionStage<Optional<Schema>> getAsync(String schemaName) {
        return ((CompletableFuture)this.protostreamCache.getAsync(schemaName).thenApply(content -> RemoteSchemasAdminImpl.getSchemaContent(schemaName, content))).exceptionally(ex -> {
            log.crudSchemaError(schemaName, (Throwable)ex);
            throw new InfinispanException(ex);
        });
    }

    @Override
    public CompletionStage<RemoteSchemasAdmin.SchemaOpResult> createAsync(Schema schema) {
        return this.callCreateOrUpdateSchema(schema, CREATE, false);
    }

    @Override
    public CompletionStage<Map<String, RemoteSchemasAdmin.SchemaOpResult>> createAsync(FileDescriptorSource fileDescriptorSource) {
        return this.createOrUpdateFileDescriptors(fileDescriptorSource, this::createAsync);
    }

    @Override
    public CompletionStage<RemoteSchemasAdmin.SchemaOpResult> updateAsync(Schema schema, boolean force) {
        return this.callCreateOrUpdateSchema(schema, UPDATE, force);
    }

    @Override
    public CompletionStage<Map<String, RemoteSchemasAdmin.SchemaOpResult>> updateAsync(FileDescriptorSource fileDescriptorSource) {
        return this.createOrUpdateFileDescriptors(fileDescriptorSource, this::updateAsync);
    }

    @Override
    public CompletionStage<RemoteSchemasAdmin.SchemaOpResult> createOrUpdateAsync(Schema schema, boolean force) {
        return this.callCreateOrUpdateSchema(schema, SAVE, force);
    }

    @Override
    public CompletionStage<Map<String, RemoteSchemasAdmin.SchemaOpResult>> createOrUpdateAsync(FileDescriptorSource fileDescriptorSource) {
        return this.createOrUpdateFileDescriptors(fileDescriptorSource, this::createOrUpdateAsync);
    }

    private CompletableFuture<Map<String, RemoteSchemasAdmin.SchemaOpResult>> createOrUpdateFileDescriptors(FileDescriptorSource fileDescriptorSource, Function<Schema, CompletionStage<RemoteSchemasAdmin.SchemaOpResult>> schemaOp) {
        Map files = fileDescriptorSource.getFiles();
        ConcurrentHashMap results = new ConcurrentHashMap(files.size());
        AggregateCompletionStage stage = CompletionStages.aggregateCompletionStage(results);
        files.forEach((schemaName, schemaContent) -> {
            CompletionStage<Void> f = ((CompletionStage)schemaOp.apply(Schema.buildFromStringContent((String)schemaName, (String)schemaContent))).thenAccept(schemaOpResult -> results.put(schemaName, schemaOpResult));
            stage.dependsOn(f);
        });
        return stage.freeze().toCompletableFuture();
    }

    @Override
    public CompletionStage<RemoteSchemasAdmin.SchemaOpResult> removeAsync(String name, boolean force) {
        if (force) {
            return this.protostreamCache.withFlags(Flag.FORCE_RETURN_VALUE).removeAsync(name).thenApply(r -> {
                if (r == null) {
                    log.schemaNotFound(name);
                    return new RemoteSchemasAdmin.SchemaOpResult(RemoteSchemasAdmin.SchemaOpResultType.NONE);
                }
                return new RemoteSchemasAdmin.SchemaOpResult(RemoteSchemasAdmin.SchemaOpResultType.DELETED);
            });
        }
        Map<String, byte[]> params = Map.of("name", RemoteCacheManagerAdminImpl.string(name));
        return this.operationDispatcher.execute(this.operationsFactory.executeOperation("@@schemas@delete", params)).thenApply(r -> new RemoteSchemasAdmin.SchemaOpResult(RemoteSchemasAdminImpl.getSchemaOpResult(name, r)));
    }

    @Override
    public CompletionStage<RemoteSchemasAdmin.SchemaErrors> retrieveAllSchemaErrorsAsync() {
        return CompletionStages.handleAndCompose((CompletionStage)this.protostreamCache.getAsync(".errors"), (errors, ex) -> {
            if (ex != null) {
                log.schemasInErrorRetrieveFailure((Throwable)ex);
                throw new InfinispanException(ex);
            }
            if (errors != null) {
                Set errorFileKeys = Stream.of(errors.split("\n")).map(errorFile -> errorFile + ".errors").collect(Collectors.toSet());
                return ((CompletableFuture)this.protostreamCache.getAllAsync(errorFileKeys).thenApply(RemoteSchemasAdmin.SchemaErrors::new)).exceptionally(ex2 -> {
                    log.schemasInErrorRetrieveFailure(errorFileKeys.toString(), (Throwable)ex2);
                    throw new InfinispanException(ex2);
                });
            }
            return CompletableFuture.completedFuture(new RemoteSchemasAdmin.SchemaErrors(null));
        });
    }

    @Override
    public CompletionStage<Optional<String>> retrieveErrorAsync(String schemaName) {
        if (log.isDebugEnabled()) {
            return CompletionStages.handleAndCompose((CompletionStage)this.protostreamCache.getAsync(schemaName), (schemaContent, ex) -> {
                if (ex != null) {
                    log.crudSchemaError(schemaName, (Throwable)ex);
                    throw new InfinispanException(ex);
                }
                if (schemaContent == null) {
                    log.debugf(String.format("Schema %s not found", schemaName), new Object[0]);
                    return CompletableFuture.completedFuture(Optional.empty());
                }
                return this.getErrorAsync(schemaName);
            });
        }
        return this.getErrorAsync(schemaName);
    }

    private CompletionStage<RemoteSchemasAdmin.SchemaOpResult> callCreateOrUpdateSchema(Schema schema, byte[] op, boolean force) {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>(4);
        params.put("name", RemoteCacheManagerAdminImpl.string(schema.getName()));
        params.put("content", RemoteCacheManagerAdminImpl.string(schema.getContent()));
        params.put("op", op);
        if (force) {
            params.put("force", FORCE);
        }
        return this.operationDispatcher.execute(this.operationsFactory.executeOperation("@@schemas@createOrUpdate", params)).thenApply(RemoteSchemasAdminImpl::createOrUpdateToSchemaOpResult).exceptionally(ex -> {
            log.crudSchemaError(schema.getName(), (Throwable)ex);
            throw new InfinispanException(ex);
        });
    }

    private static Optional<Schema> getSchemaContent(String schemaName, String schemaContent) {
        if (schemaContent != null) {
            return Optional.of(Schema.buildFromStringContent((String)schemaName, (String)schemaContent));
        }
        return Optional.empty();
    }

    private static RemoteSchemasAdmin.SchemaOpResult createOrUpdateToSchemaOpResult(String opResult) {
        char c = opResult.charAt(0);
        RemoteSchemasAdmin.SchemaOpResultType schemaOpResultType = RemoteSchemasAdmin.SchemaOpResultType.fromCode(c);
        if (opResult.length() == 1) {
            return new RemoteSchemasAdmin.SchemaOpResult(schemaOpResultType);
        }
        String error = opResult.substring(2);
        return new RemoteSchemasAdmin.SchemaOpResult(schemaOpResultType, error);
    }

    private static RemoteSchemasAdmin.SchemaOpResultType getSchemaOpResult(String schemaName, String opResult) {
        int safeDelete = Integer.parseInt(opResult);
        if (safeDelete < 0) {
            log.notSafeDelete(schemaName);
            throw new InfinispanException(String.format("A cache is using one entity in the schema %s. Remove not done", schemaName));
        }
        if (safeDelete == 1) {
            return RemoteSchemasAdmin.SchemaOpResultType.DELETED;
        }
        log.debugf(String.format("Schema %s not found", schemaName), new Object[0]);
        return RemoteSchemasAdmin.SchemaOpResultType.NONE;
    }

    private CompletionStage<Optional<String>> getErrorAsync(String schemaName) {
        return ((CompletableFuture)this.protostreamCache.getAsync(schemaName + ".errors").thenApply(Optional::ofNullable)).exceptionally(ex -> {
            log.crudSchemaError(schemaName, (Throwable)ex);
            throw new InfinispanException(ex);
        });
    }
}

