/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import org.infinispan.client.hotrod.configuration.AbstractConfigurationChildBuilder;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.near.DefaultNearCacheFactory;
import org.infinispan.client.hotrod.near.NearCacheFactory;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;

public class NearCacheConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<NearCacheConfiguration> {
    private NearCacheMode mode = NearCacheMode.DISABLED;
    private Integer maxEntries = null;
    private boolean bloomFilter = false;
    private NearCacheFactory nearCacheFactory = DefaultNearCacheFactory.INSTANCE;

    protected NearCacheConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public AttributeSet attributes() {
        return AttributeSet.EMPTY;
    }

    public NearCacheConfigurationBuilder maxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
        return this;
    }

    public NearCacheConfigurationBuilder bloomFilter(boolean enable) {
        this.bloomFilter = enable;
        return this;
    }

    public NearCacheConfigurationBuilder mode(NearCacheMode mode) {
        this.mode = mode;
        return this;
    }

    public NearCacheConfigurationBuilder nearCacheFactory(NearCacheFactory factory) {
        this.nearCacheFactory = factory;
        return this;
    }

    public void validate() {
        if (this.mode.enabled()) {
            if (this.maxEntries == null) {
                throw Log.HOTROD.nearCacheMaxEntriesUndefined();
            }
            if (this.maxEntries < 0 && this.bloomFilter) {
                throw Log.HOTROD.nearCacheMaxEntriesPositiveWithBloom(this.maxEntries);
            }
        }
    }

    public NearCacheConfiguration create() {
        return new NearCacheConfiguration(this.mode, this.maxEntries == null ? -1 : this.maxEntries, this.bloomFilter, this.nearCacheFactory);
    }

    public Builder<?> read(NearCacheConfiguration template, Combine combine) {
        this.mode = template.mode();
        this.maxEntries = template.maxEntries();
        this.bloomFilter = template.bloomFilter();
        this.nearCacheFactory = template.nearCacheFactory();
        return this;
    }
}

