/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.FailoverRequestBalancingStrategy;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.TransportFactory;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.configuration.ClusterConfiguration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ConnectionPoolConfiguration;
import org.infinispan.client.hotrod.configuration.ExecutorFactoryConfiguration;
import org.infinispan.client.hotrod.configuration.RemoteCacheConfiguration;
import org.infinispan.client.hotrod.configuration.RemoteCacheConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.SecurityConfiguration;
import org.infinispan.client.hotrod.configuration.ServerConfiguration;
import org.infinispan.client.hotrod.configuration.StatisticsConfiguration;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.metrics.RemoteCacheManagerMetricsRegistry;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Features;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.protostream.SerializationContextInitializer;

@BuiltBy(value=ConfigurationBuilder.class)
public class Configuration
implements org.infinispan.api.configuration.Configuration {
    private final ExecutorFactoryConfiguration asyncExecutorFactory;
    private final Supplier<FailoverRequestBalancingStrategy> balancingStrategyFactory;
    private final WeakReference<ClassLoader> classLoader;
    private final ClientIntelligence clientIntelligence;
    private final ConnectionPoolConfiguration connectionPool;
    private final int connectionTimeout;
    private final Class<? extends ConsistentHash>[] consistentHashImpl;
    private final boolean forceReturnValues;
    private final Class<? extends Marshaller> marshallerClass;
    private final Marshaller marshaller;
    private final ProtocolVersion protocolVersion;
    private final List<ServerConfiguration> servers;
    private final int socketTimeout;
    private final SecurityConfiguration security;
    private final boolean tcpNoDelay;
    private final boolean tcpKeepAlive;
    private final int maxRetries;
    private final List<ClusterConfiguration> clusters;
    private final List<String> serialAllowList;
    private final int batchSize;
    private final ClassAllowList classAllowList;
    private final StatisticsConfiguration statistics;
    private final Features features;
    private final List<SerializationContextInitializer> contextInitializers;
    private final Map<String, RemoteCacheConfiguration> remoteCaches;
    private final TransportFactory transportFactory;
    private final boolean tracingPropagationEnabled;
    private final int dnsResolverMinTTL;
    private final int dnsResolverMaxTTL;
    private final int dnsResolverNegativeTTL;
    private final RemoteCacheManagerMetricsRegistry metricRegistry;
    private final int serverFailureTimeout;
    private final long transactionTimeout;

    public Configuration(ExecutorFactoryConfiguration asyncExecutorFactory, Supplier<FailoverRequestBalancingStrategy> balancingStrategyFactory, ClassLoader classLoader, ClientIntelligence clientIntelligence, ConnectionPoolConfiguration connectionPool, int connectionTimeout, Class<? extends ConsistentHash>[] consistentHashImpl, int dnsResolverMinTTL, int dnsResolverMaxTTL, int dnsResolverNegativeTTL, boolean forceReturnValues, Marshaller marshaller, Class<? extends Marshaller> marshallerClass, ProtocolVersion protocolVersion, List<ServerConfiguration> servers, int socketTimeout, SecurityConfiguration security, boolean tcpNoDelay, boolean tcpKeepAlive, int maxRetries, List<ClusterConfiguration> clusters, List<String> serialAllowList, int batchSize, long transactionTimeout, StatisticsConfiguration statistics, Features features, List<SerializationContextInitializer> contextInitializers, Map<String, RemoteCacheConfiguration> remoteCaches, TransportFactory transportFactory, boolean tracingPropagationEnabled, RemoteCacheManagerMetricsRegistry metricRegistry, int serverFailureTimeout) {
        this.asyncExecutorFactory = asyncExecutorFactory;
        this.balancingStrategyFactory = balancingStrategyFactory;
        this.maxRetries = maxRetries;
        this.classLoader = new WeakReference<ClassLoader>(classLoader);
        this.clientIntelligence = clientIntelligence;
        this.connectionPool = connectionPool;
        this.connectionTimeout = connectionTimeout;
        this.consistentHashImpl = consistentHashImpl;
        this.dnsResolverMinTTL = dnsResolverMinTTL;
        this.dnsResolverMaxTTL = dnsResolverMaxTTL;
        this.dnsResolverNegativeTTL = dnsResolverNegativeTTL;
        this.forceReturnValues = forceReturnValues;
        this.marshallerClass = marshallerClass;
        this.marshaller = marshaller;
        this.protocolVersion = protocolVersion;
        this.servers = List.copyOf(servers);
        this.socketTimeout = socketTimeout;
        this.security = security;
        this.tcpNoDelay = tcpNoDelay;
        this.tcpKeepAlive = tcpKeepAlive;
        this.clusters = clusters;
        this.serialAllowList = serialAllowList;
        this.classAllowList = new ClassAllowList(serialAllowList);
        this.batchSize = batchSize;
        this.transactionTimeout = transactionTimeout;
        this.statistics = statistics;
        this.features = features;
        this.contextInitializers = contextInitializers;
        this.remoteCaches = remoteCaches;
        this.transportFactory = transportFactory;
        this.tracingPropagationEnabled = tracingPropagationEnabled;
        this.metricRegistry = Objects.requireNonNullElse(metricRegistry, RemoteCacheManagerMetricsRegistry.DISABLED);
        this.serverFailureTimeout = serverFailureTimeout;
    }

    public ExecutorFactoryConfiguration asyncExecutorFactory() {
        return this.asyncExecutorFactory;
    }

    public Supplier<FailoverRequestBalancingStrategy> balancingStrategyFactory() {
        return this.balancingStrategyFactory;
    }

    @Deprecated(forRemoval=true)
    public ClassLoader classLoader() {
        return (ClassLoader)this.classLoader.get();
    }

    public ClientIntelligence clientIntelligence() {
        return this.clientIntelligence;
    }

    public ConnectionPoolConfiguration connectionPool() {
        return this.connectionPool;
    }

    public int connectionTimeout() {
        return this.connectionTimeout;
    }

    public Class<? extends ConsistentHash>[] consistentHashImpl() {
        return Arrays.copyOf(this.consistentHashImpl, this.consistentHashImpl.length);
    }

    public Class<? extends ConsistentHash> consistentHashImpl(int version) {
        return this.consistentHashImpl[version - 1];
    }

    public int dnsResolverMinTTL() {
        return this.dnsResolverMinTTL;
    }

    public int dnsResolverMaxTTL() {
        return this.dnsResolverMaxTTL;
    }

    public int dnsResolverNegativeTTL() {
        return this.dnsResolverNegativeTTL;
    }

    public boolean forceReturnValues() {
        return this.forceReturnValues;
    }

    public Marshaller marshaller() {
        return this.marshaller;
    }

    public Class<? extends Marshaller> marshallerClass() {
        return this.marshallerClass;
    }

    public ProtocolVersion version() {
        return this.protocolVersion;
    }

    public List<ServerConfiguration> servers() {
        return this.servers;
    }

    public List<ClusterConfiguration> clusters() {
        return this.clusters;
    }

    public int socketTimeout() {
        return this.socketTimeout;
    }

    public SecurityConfiguration security() {
        return this.security;
    }

    public boolean tcpNoDelay() {
        return this.tcpNoDelay;
    }

    public boolean tcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public int maxRetries() {
        return this.maxRetries;
    }

    public List<String> serialAllowList() {
        return this.serialAllowList;
    }

    public ClassAllowList getClassAllowList() {
        return this.classAllowList;
    }

    public int batchSize() {
        return this.batchSize;
    }

    public Map<String, RemoteCacheConfiguration> remoteCaches() {
        return Collections.unmodifiableMap(this.remoteCaches);
    }

    public RemoteCacheConfiguration addRemoteCache(String name, Consumer<RemoteCacheConfigurationBuilder> builderConsumer) {
        return this.remoteCaches.compute(name, (ignore, existent) -> {
            if (existent != null) {
                throw Log.HOTROD.duplicateCacheConfiguration(name);
            }
            RemoteCacheConfigurationBuilder builder = new RemoteCacheConfigurationBuilder(null, name);
            builderConsumer.accept(builder);
            builder.validate();
            return builder.create();
        });
    }

    public void removeRemoteCache(String name) {
        this.remoteCaches.remove(name);
    }

    public StatisticsConfiguration statistics() {
        return this.statistics;
    }

    public long transactionTimeout() {
        return this.transactionTimeout;
    }

    public Features features() {
        return this.features;
    }

    public List<SerializationContextInitializer> getContextInitializers() {
        return this.contextInitializers;
    }

    public TransportFactory transportFactory() {
        return this.transportFactory;
    }

    public boolean tracingPropagationEnabled() {
        return this.tracingPropagationEnabled;
    }

    public RemoteCacheManagerMetricsRegistry metricRegistry() {
        return this.metricRegistry;
    }

    public int serverFailureTimeout() {
        return this.serverFailureTimeout;
    }

    public String toString() {
        return "Configuration [asyncExecutorFactory=" + String.valueOf((Object)this.asyncExecutorFactory) + ", balancingStrategyFactory=()->" + String.valueOf(this.balancingStrategyFactory.get()) + ",classLoader=" + String.valueOf(this.classLoader) + ", clientIntelligence=" + String.valueOf((Object)this.clientIntelligence) + ", connectionPool=" + String.valueOf(this.connectionPool) + ", connectionTimeout=" + this.connectionTimeout + ", consistentHashImpl=" + Arrays.toString(this.consistentHashImpl) + ", forceReturnValues=" + this.forceReturnValues + ", marshallerClass=" + String.valueOf(this.marshallerClass) + ", marshaller=" + String.valueOf(this.marshaller) + ", protocolVersion=" + String.valueOf((Object)this.protocolVersion) + ", servers=" + String.valueOf(this.servers) + ", socketTimeout=" + this.socketTimeout + ", security=" + String.valueOf(this.security) + ", tcpNoDelay=" + this.tcpNoDelay + ", tcpKeepAlive=" + this.tcpKeepAlive + ", maxRetries=" + this.maxRetries + ", serialAllowList=" + String.valueOf(this.serialAllowList) + ", batchSize=" + this.batchSize + ", remoteCaches= " + String.valueOf(this.remoteCaches) + ", transactionTimeout=" + this.transactionTimeout + ", statistics=" + String.valueOf(this.statistics) + ", metricRegistry=" + String.valueOf(this.metricRegistry) + ", serverFailureTimeout=" + this.serverFailureTimeout + "]";
    }

    public Properties properties() {
        TypedProperties properties = new TypedProperties();
        if (this.asyncExecutorFactory().factoryClass() != null) {
            properties.setProperty("infinispan.client.hotrod.async_executor_factory", this.asyncExecutorFactory().factoryClass().getName());
            TypedProperties aefProps = this.asyncExecutorFactory().properties();
            if (aefProps.containsKey((Object)"infinispan.client.hotrod.default_executor_factory.pool_size")) {
                properties.setProperty("infinispan.client.hotrod.default_executor_factory.pool_size", aefProps.getProperty("infinispan.client.hotrod.default_executor_factory.pool_size"));
            }
        }
        properties.setProperty("infinispan.client.hotrod.request_balancing_strategy", this.balancingStrategyFactory().get().getClass().getName());
        properties.setProperty("infinispan.client.hotrod.client_intelligence", this.clientIntelligence().name());
        properties.setProperty("infinispan.client.hotrod.connect_timeout", Integer.toString(this.connectionTimeout()));
        for (int i = 0; i < this.consistentHashImpl().length; ++i) {
            int version = i + 1;
            if (this.consistentHashImpl(version) == null) continue;
            properties.setProperty("infinispan.client.hotrod.hash_function_impl." + version, this.consistentHashImpl(version).getName());
        }
        properties.setProperty("infinispan.client.hotrod.force_return_values", this.forceReturnValues());
        properties.setProperty("infinispan.client.hotrod.marshaller", this.marshallerClass().getName());
        properties.setProperty("infinispan.client.hotrod.protocol_version", this.version().toString());
        properties.setProperty("infinispan.client.hotrod.socket_timeout", this.socketTimeout());
        properties.setProperty("infinispan.client.hotrod.tcp_no_delay", this.tcpNoDelay());
        properties.setProperty("infinispan.client.hotrod.tcp_keep_alive", this.tcpKeepAlive());
        properties.setProperty("infinispan.client.hotrod.max_retries", this.maxRetries());
        properties.setProperty("infinispan.client.hotrod.statistics", this.statistics().enabled());
        properties.setProperty("infinispan.client.hotrod.server_failure_timeout", this.serverFailureTimeout());
        properties.setProperty(".dns_resolver_min_ttl", this.dnsResolverMinTTL);
        properties.setProperty(".dns_resolver_max_ttl", this.dnsResolverMaxTTL);
        properties.setProperty(".dns_resolver_negative_ttl", this.dnsResolverNegativeTTL);
        String servers = this.servers().stream().map(server -> server.host() + ":" + server.port()).collect(Collectors.joining(";"));
        properties.setProperty("infinispan.client.hotrod.server_list", servers);
        properties.setProperty("infinispan.client.hotrod.use_ssl", Boolean.toString(this.security.ssl().enabled()));
        if (this.security.ssl().keyStoreFileName() != null) {
            properties.setProperty("infinispan.client.hotrod.key_store_file_name", this.security.ssl().keyStoreFileName());
        }
        if (this.security.ssl().keyStorePassword() != null) {
            properties.setProperty("infinispan.client.hotrod.key_store_password", new String(this.security.ssl().keyStorePassword()));
        }
        if (this.security.ssl().trustStoreFileName() != null) {
            properties.setProperty("infinispan.client.hotrod.trust_store_file_name", this.security.ssl().trustStoreFileName());
        }
        if (this.security.ssl().trustStorePassword() != null) {
            properties.setProperty("infinispan.client.hotrod.trust_store_password", new String(this.security.ssl().trustStorePassword()));
        }
        if (this.security.ssl().sniHostName() != null) {
            properties.setProperty("infinispan.client.hotrod.sni_host_name", this.security.ssl().sniHostName());
        }
        if (this.security.ssl().protocol() != null) {
            properties.setProperty("infinispan.client.hotrod.ssl_protocol", this.security.ssl().protocol());
        }
        if (this.security.ssl().sslContext() != null) {
            properties.put((Object)"infinispan.client.hotrod.ssl_context", (Object)this.security.ssl().sslContext());
        }
        properties.setProperty("infinispan.client.hotrod.use_auth", Boolean.toString(this.security.authentication().enabled()));
        if (this.security.authentication().saslMechanism() != null) {
            properties.setProperty("infinispan.client.hotrod.sasl_mechanism", this.security.authentication().saslMechanism());
        }
        if (this.security.authentication().callbackHandler() != null) {
            properties.put((Object)"infinispan.client.hotrod.auth_callback_handler", (Object)this.security.authentication().callbackHandler());
        }
        if (this.security.authentication().serverName() != null) {
            properties.setProperty("infinispan.client.hotrod.auth_server_name", this.security.authentication().serverName());
        }
        if (this.security.authentication().clientSubject() != null) {
            properties.put((Object)"infinispan.client.hotrod.auth_client_subject", (Object)this.security.authentication().clientSubject());
        }
        for (Map.Entry<String, String> entry : this.security.authentication().saslProperties().entrySet()) {
            properties.setProperty("infinispan.client.hotrod.sasl_properties." + entry.getKey(), entry.getValue());
        }
        properties.setProperty("infinispan.client.hotrod.java_serial_allowlist", String.join((CharSequence)",", this.serialAllowList));
        properties.setProperty("infinispan.client.hotrod.batch_size", Integer.toString(this.batchSize));
        properties.setProperty("infinispan.client.hotrod.transaction.timeout", Long.toString(this.transactionTimeout));
        if (this.contextInitializers != null && !this.contextInitializers.isEmpty()) {
            properties.setProperty("infinispan.client.hotrod.context-initializers", this.contextInitializers.stream().map(sci -> sci.getClass().getName()).collect(Collectors.joining(",")));
        }
        for (RemoteCacheConfiguration remoteCache : this.remoteCaches.values()) {
            String prefix = "infinispan.client.hotrod.cache." + remoteCache.name();
            if (remoteCache.templateName() != null) {
                properties.setProperty(prefix + ".template_name", remoteCache.templateName());
            }
            if (remoteCache.configuration() != null) {
                properties.setProperty(prefix + ".configuration", remoteCache.configuration());
            }
            properties.setProperty(prefix + ".near_cache.mode", remoteCache.nearCacheMode().name());
            properties.setProperty(prefix + ".near_cache.mode", remoteCache.nearCacheMaxEntries());
            Marshaller marshaller = remoteCache.marshaller();
            if (marshaller != null) {
                properties.setProperty(prefix + ".marshaller", remoteCache.marshaller().getClass().getName());
                continue;
            }
            Class<? extends Marshaller> marshallerClass = remoteCache.marshallerClass();
            if (marshallerClass == null) continue;
            properties.setProperty(prefix + ".marshaller", marshallerClass.getName());
        }
        return properties;
    }
}

