/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ByteBufSwappableInputStream
extends InputStream {
    private ByteBuf buffer;
    private int unavailableBytes;

    public void setBuffer(ByteBuf buffer, int readLimit) {
        this.buffer = buffer;
        this.unavailableBytes = buffer.readableBytes() - readLimit;
    }

    @Override
    public int available() throws IOException {
        return this.buffer.readableBytes() - this.unavailableBytes;
    }

    @Override
    public void mark(int readlimit) {
        this.buffer.markReaderIndex();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        int available = this.available();
        return available == 0 ? -1 : this.buffer.readByte() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int available = this.available();
        if (available == 0) {
            return -1;
        }
        len = Math.min(available, len);
        this.buffer.readBytes(b, off, len);
        return len;
    }

    @Override
    public void reset() throws IOException {
        this.buffer.resetReaderIndex();
    }

    @Override
    public long skip(long n) throws IOException {
        return n > Integer.MAX_VALUE ? (long)this.skipBytes(Integer.MAX_VALUE) : (long)this.skipBytes((int)n);
    }

    public byte readByte() throws IOException {
        int available = this.available();
        if (available == 0) {
            throw new EOFException();
        }
        return this.buffer.readByte();
    }

    public int skipBytes(int n) throws IOException {
        int nBytes = Math.min(this.available(), n);
        this.buffer.skipBytes(nBytes);
        return nBytes;
    }
}

