/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.graalvm;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Stream;
import org.graalvm.nativeimage.hosted.Feature;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.impl.consistenthash.SegmentConsistentHash;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.graalvm.Bundle;
import org.infinispan.commons.graalvm.ClassLoaderFeatureAccess;
import org.infinispan.commons.graalvm.Jandex;
import org.infinispan.commons.graalvm.ReflectionProcessor;
import org.infinispan.commons.graalvm.ReflectiveClass;
import org.infinispan.commons.graalvm.Resource;
import org.infinispan.commons.jmx.PlatformMBeanServerLookup;
import org.infinispan.protostream.GeneratedSchema;
import org.infinispan.query.api.continuous.ContinuousQuery;
import org.infinispan.query.remote.client.ProtobufMetadataManagerConstants;
import org.jboss.jandex.IndexView;
import org.jboss.logging.BasicLogger;

public class NativeMetadataProvider
implements org.infinispan.commons.graalvm.NativeMetadataProvider {
    static final Collection<Resource> resourceFiles = Resource.of((String[])new String[]{"org/infinispan/protostream/message-wrapping\\.proto", "org/infinispan/query/remote/client/query\\.proto", "protostream/common-java-types\\.proto", "protostream/common-java-container-types\\.proto"});
    static final Collection<Resource> resourceRegexps = Collections.emptyList();
    static final Collection<Bundle> bundles = Collections.emptyList();
    final Feature.FeatureAccess featureAccess;
    final ReflectionProcessor reflection;

    public NativeMetadataProvider() {
        this((Feature.FeatureAccess)new ClassLoaderFeatureAccess(NativeMetadataProvider.class.getClassLoader()));
    }

    public NativeMetadataProvider(Feature.FeatureAccess featureAccess) {
        this.featureAccess = featureAccess;
        this.reflection = this.reflectionProcessor();
    }

    public Stream<ReflectiveClass> reflectiveClasses() {
        return this.reflection.classes();
    }

    public Stream<Resource> includedResources() {
        return Stream.of(resourceFiles.stream(), resourceRegexps.stream()).flatMap(Function.identity());
    }

    public Stream<Bundle> bundles() {
        return bundles.stream();
    }

    private ReflectionProcessor reflectionProcessor() {
        IndexView index = Jandex.createIndex((Class[])new Class[]{GeneratedSchema.class, CacheException.class, RemoteCache.class, ProtobufMetadataManagerConstants.class, ContinuousQuery.class});
        return new ReflectionProcessor(this.featureAccess, index).addImplementations(false, false, new Class[]{BasicLogger.class, ExecutorFactory.class}).addClasses(new Class[]{PlatformMBeanServerLookup.class, SegmentConsistentHash.class}).addClasses(new String[]{"org.wildfly.security.sasl.plain.WildFlyElytronSaslPlainProvider", "org.wildfly.security.sasl.digest.WildFlyElytronSaslDigestProvider", "org.wildfly.security.sasl.external.WildFlyElytronSaslExternalProvider", "org.wildfly.security.sasl.oauth2.WildFlyElytronSaslOAuth2Provider", "org.wildfly.security.sasl.scram.WildFlyElytronSaslScramProvider", "org.wildfly.security.sasl.gssapi.WildFlyElytronSaslGssapiProvider", "org.wildfly.security.sasl.gs2.WildFlyElytronSaslGs2Provider", "org.infinispan.client.hotrod.event.impl.ContinuousQueryImpl$ClientEntryListener", "org.infinispan.client.hotrod.near.NearCacheService$InvalidatedNearCacheListener", "java.time.ZoneRegion"});
    }
}

