/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.benchmark;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.util.Util;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Thread)
public class HotRodBenchmark {
    RemoteCacheManager cm;
    RemoteCache cache;
    @Param(value={"hotrod://127.0.0.1"})
    public String uri;
    @Param(value={"benchmark"})
    public String cacheName;
    @Param(value={"16"})
    public int keySize;
    @Param(value={"1000"})
    public int valueSize;
    @Param(value={"1000"})
    public int keySetSize;
    byte[] value;
    List<byte[]> keySet;
    AtomicInteger nextIndex;

    @Setup
    public void setup() {
        this.cm = new RemoteCacheManager(this.uri);
        this.cache = this.cm.getCache(this.cacheName);
        if (this.cache == null) {
            throw new IllegalArgumentException("Could not find cache " + this.cacheName);
        }
        this.value = new byte[this.valueSize];
        this.keySet = new ArrayList<byte[]>(this.keySetSize);
        Random r = new Random(17L);
        for (int i = 0; i < this.keySetSize; ++i) {
            byte[] key = new byte[this.keySize];
            r.nextBytes(key);
            this.keySet.add(key);
            this.cache.put((Object)key, (Object)this.value);
        }
        this.nextIndex = new AtomicInteger();
    }

    @Benchmark
    public void get(Blackhole bh) {
        bh.consume(this.cache.get((Object)this.nextKey()));
    }

    @Benchmark
    public void put() {
        this.cache.put((Object)this.nextKey(), (Object)this.value);
    }

    @TearDown
    public void teardown() {
        Util.close((AutoCloseable)this.cm);
    }

    private byte[] nextKey() {
        return this.keySet.get(this.nextIndex.getAndIncrement() % this.keySetSize);
    }
}

