/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.rest;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.command.option.OptionList;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.rest.RestCliCommand;
import org.infinispan.cli.completers.ConnectorCompleter;
import org.infinispan.cli.completers.IpFilterRuleCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.logging.Messages;
import org.infinispan.cli.resources.Resource;
import org.infinispan.client.rest.IpFilterRule;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;

@GroupCommandDefinition(name="connector", description="Performs operations on protocol connectors", activator=ConnectionActivator.class, groupCommands={Ls.class, Describe.class, Start.class, Stop.class, IpFilter.class})
public class Connector
extends CliCommand {
    public static final String CMD = "connector";
    public static final String TYPE = "type";
    public static final String NAME = "name";
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        invocation.println(invocation.getHelpInfo());
        return CommandResult.FAILURE;
    }

    @GroupCommandDefinition(name="ipfilter", description="Manages connector IP filters", activator=ConnectionActivator.class, groupCommands={Ls.class, Clear.class, Set.class})
    public static class IpFilter
    extends CliCommand {
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        protected boolean isHelp() {
            return this.help;
        }

        @Override
        protected CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
            return CommandResult.FAILURE;
        }

        @CommandDefinition(name="set", description="Sets IP Filters on a connector", activator=ConnectionActivator.class)
        public static class Set
        extends RestCliCommand {
            @Argument(required=true, completer=ConnectorCompleter.class)
            String name;
            @OptionList(description="One or more filter rules as \"[ACCEPT|REJECT]/CIDR\"", completer=IpFilterRuleCompleter.class, required=true)
            List<String> rules;
            @Option(shortName=104, hasValue=false, overrideRequired=true)
            protected boolean help;

            @Override
            public boolean isHelp() {
                return this.help;
            }

            @Override
            protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
                ArrayList<IpFilterRule> filterRules = new ArrayList<IpFilterRule>(this.rules.size());
                for (String rule : this.rules) {
                    int i = rule.indexOf(47);
                    if (i < 0) {
                        throw Messages.MSG.illegalFilterRule(rule);
                    }
                    IpFilterRule.RuleType ruleType = IpFilterRule.RuleType.valueOf((String)rule.substring(0, i));
                    filterRules.add(new IpFilterRule(ruleType, rule.substring(i + 1)));
                }
                return client.server().connectorIpFilterSet(this.name, filterRules);
            }
        }

        @CommandDefinition(name="clear", description="Removes all IP Filters from a connector", activator=ConnectionActivator.class)
        public static class Clear
        extends RestCliCommand {
            @Argument(required=true, completer=ConnectorCompleter.class)
            String name;
            @Option(shortName=104, hasValue=false, overrideRequired=true)
            protected boolean help;

            @Override
            public boolean isHelp() {
                return this.help;
            }

            @Override
            protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
                return client.server().connectorIpFiltersClear(this.name);
            }
        }

        @CommandDefinition(name="ls", description="List all IP filters on a connector", activator=ConnectionActivator.class)
        public static class Ls
        extends RestCliCommand {
            @Argument(required=true, completer=ConnectorCompleter.class)
            String name;
            @Option(shortName=104, hasValue=false, overrideRequired=true)
            protected boolean help;

            @Override
            public boolean isHelp() {
                return this.help;
            }

            @Override
            protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
                return client.server().connectorIpFilters(this.name);
            }
        }
    }

    @CommandDefinition(name="stop", description="Stops a connector", activator=ConnectionActivator.class)
    public static class Stop
    extends RestCliCommand {
        @Argument(required=true, completer=ConnectorCompleter.class)
        String name;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.server().connectorStop(this.name);
        }
    }

    @CommandDefinition(name="start", description="Starts a connector", activator=ConnectionActivator.class)
    public static class Start
    extends RestCliCommand {
        @Argument(required=true, completer=ConnectorCompleter.class)
        String name;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.server().connectorStart(this.name);
        }
    }

    @CommandDefinition(name="describe", description="Describes a connector", activator=ConnectionActivator.class)
    public static class Describe
    extends RestCliCommand {
        @Argument(required=true, completer=ConnectorCompleter.class)
        String name;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.server().connector(this.name);
        }
    }

    @CommandDefinition(name="ls", description="Lists connectors", activator=ConnectionActivator.class)
    public static class Ls
    extends RestCliCommand {
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.server().connectorNames();
        }
    }
}

