/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.patching;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.cli.patching.PatchOperation;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;

public class PatchInfo
implements JsonSerialization {
    private static final String BRAND_NAME = "brandName";
    private static final String SOURCE_VERSION = "sourceVersion";
    private static final String TARGET_VERSION = "targetVersion";
    private static final String QUALIFIER = "qualifier";
    private static final String CREATION_DATE = "creationDate";
    private static final String INSTALLATION_DATE = "installationDate";
    private static final String OPERATIONS = "operations";
    private final Date creationDate;
    private Date installationDate;
    private final String brandName;
    private final String sourceVersion;
    private final String targetVersion;
    private final String qualifier;
    private final List<PatchOperation> operations;

    public PatchInfo(String brandName, String sourceVersion, String targetVersion, String qualifier) {
        this(brandName, sourceVersion, targetVersion, qualifier, new Date(), null, new ArrayList<PatchOperation>());
    }

    PatchInfo(String brandName, String sourceVersion, String targetVersion, String qualifier, Date creationDate, Date installationDate, List<PatchOperation> operations) {
        this.brandName = brandName;
        this.sourceVersion = sourceVersion;
        this.targetVersion = targetVersion;
        this.qualifier = qualifier;
        this.creationDate = creationDate;
        this.installationDate = installationDate;
        this.operations = operations;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getBrandName() {
        return this.brandName;
    }

    public String getSourceVersion() {
        return this.sourceVersion;
    }

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public List<PatchOperation> getOperations() {
        return this.operations;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Date getInstallationDate() {
        return this.installationDate;
    }

    public void setInstallationDate(Date installationDate) {
        this.installationDate = installationDate;
    }

    public String toString() {
        return this.brandName + " patch target=" + this.targetVersion + (this.qualifier.isEmpty() ? "" : "(" + this.qualifier + ")") + " source=" + this.sourceVersion + " created=" + this.creationDate + (this.installationDate != null ? " installed=" + this.installationDate : "");
    }

    public static PatchInfo fromJson(Json json) {
        Date creationValue;
        String qualifierValue;
        Json brandName = json.at(BRAND_NAME);
        Json sourceVersion = json.at(SOURCE_VERSION);
        Json targetVersion = json.at(TARGET_VERSION);
        Json qualifier = json.at(QUALIFIER);
        Json creationDate = json.at(CREATION_DATE);
        Json installationDate = json.at(INSTALLATION_DATE);
        Json operations = json.at(OPERATIONS);
        String brandValue = brandName != null ? brandName.asString() : null;
        String sourceValue = sourceVersion != null ? sourceVersion.asString() : null;
        String targetValue = targetVersion != null ? targetVersion.asString() : null;
        String string = qualifierValue = qualifier != null ? qualifier.asString() : null;
        Date date = creationDate != null ? (creationDate.isNull() ? null : new Date(creationDate.asLong())) : (creationValue = null);
        Date installationValue = installationDate != null ? (installationDate.isNull() ? null : new Date(installationDate.asLong())) : null;
        List<PatchOperation> operationsValue = operations != null ? operations.asJsonList().stream().map(PatchOperation::fromJson).collect(Collectors.toList()) : null;
        return new PatchInfo(brandValue, sourceValue, targetValue, qualifierValue, creationValue, installationValue, operationsValue);
    }

    public Json toJson() {
        return Json.object().set(BRAND_NAME, (Object)this.brandName).set(SOURCE_VERSION, (Object)this.sourceVersion).set(TARGET_VERSION, (Object)this.targetVersion).set(QUALIFIER, (Object)this.qualifier).set(CREATION_DATE, this.creationDate != null ? Long.valueOf(this.creationDate.getTime()) : null).set(INSTALLATION_DATE, this.installationDate != null ? Long.valueOf(this.installationDate.getTime()) : null).set(OPERATIONS, Json.make(this.operations));
    }
}

