/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.impl;

import java.io.Console;
import java.io.IOException;
import org.aesh.command.shell.Shell;
import org.aesh.readline.Prompt;
import org.aesh.readline.terminal.Key;
import org.aesh.readline.util.Parser;
import org.aesh.terminal.tty.Size;
import org.aesh.terminal.utils.ANSI;

public class DefaultShell
implements Shell {
    public void write(String out, boolean paging) {
        System.out.print(out);
    }

    public void writeln(String out, boolean paging) {
        System.out.println(out);
    }

    public void write(int[] out) {
        Console console = System.console();
        if (console != null) {
            console.writer().write(Parser.fromCodePoints((int[])out));
            console.writer().flush();
        }
    }

    public void write(char out) {
        System.out.println(out);
    }

    public String readLine() {
        return this.readLine(new Prompt());
    }

    public String readLine(Prompt prompt) {
        Console console = System.console();
        if (console != null) {
            if (prompt != null) {
                console.writer().print(Parser.fromCodePoints((int[])prompt.getANSI()));
                console.writer().flush();
                if (prompt.isMasking()) {
                    return new String(console.readPassword());
                }
            }
            return console.readLine();
        }
        return null;
    }

    public Key read() {
        return this.read(null);
    }

    public Key read(Prompt prompt) {
        Console console = System.console();
        if (console != null) {
            try {
                if (prompt != null) {
                    console.writer().print(Parser.fromCodePoints((int[])prompt.getANSI()));
                    console.writer().flush();
                }
                int input = console.reader().read();
                return Key.getKey((int[])new int[]{input});
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean enableAlternateBuffer() {
        return false;
    }

    public boolean enableMainBuffer() {
        return false;
    }

    public Size size() {
        return new Size(1, -1);
    }

    public void clear() {
        Console console = System.console();
        if (console != null) {
            console.writer().write(Parser.fromCodePoints((int[])ANSI.CLEAR_SCREEN));
        }
    }
}

