/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rocksdb.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.rocksdb.configuration.CompressionType;
import org.infinispan.persistence.rocksdb.configuration.RocksDBExpirationConfiguration;
import org.infinispan.persistence.rocksdb.configuration.RocksDBExpirationConfigurationBuilder;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfiguration;

public class RocksDBStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<RocksDBStoreConfiguration, RocksDBStoreConfigurationBuilder> {
    protected RocksDBExpirationConfigurationBuilder expiration = new RocksDBExpirationConfigurationBuilder();

    public RocksDBStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        this(builder, RocksDBStoreConfiguration.attributeDefinitionSet());
    }

    public RocksDBStoreConfigurationBuilder(PersistenceConfigurationBuilder builder, AttributeSet attributeSet) {
        super(builder, attributeSet);
    }

    public RocksDBStoreConfigurationBuilder location(String location) {
        this.attributes.attribute(RocksDBStoreConfiguration.LOCATION).set((Object)location);
        return this.self();
    }

    public RocksDBStoreConfigurationBuilder expiredLocation(String expiredLocation) {
        this.expiration.expiredLocation(expiredLocation);
        return this.self();
    }

    @Deprecated(forRemoval=true, since="10.1")
    public RocksDBStoreConfigurationBuilder blockSize(int blockSize) {
        return this.self();
    }

    @Deprecated(forRemoval=true, since="10.1")
    public RocksDBStoreConfigurationBuilder cacheSize(long cacheSize) {
        return this.self();
    }

    @Deprecated(forRemoval=true, since="12.0")
    public RocksDBStoreConfigurationBuilder clearThreshold(int clearThreshold) {
        return this.self();
    }

    public RocksDBStoreConfigurationBuilder compressionType(CompressionType compressionType) {
        this.attributes.attribute(RocksDBStoreConfiguration.COMPRESSION_TYPE).set((Object)compressionType);
        return this.self();
    }

    public void validate() {
        super.validate();
        this.expiration.validate();
    }

    public void validate(GlobalConfiguration globalConfig) {
        PersistenceUtil.validateGlobalStateStoreLocation((GlobalConfiguration)globalConfig, (String)RocksDBStoreConfiguration.class.getSimpleName(), (Attribute[])new Attribute[]{this.attributes.attribute(RocksDBStoreConfiguration.LOCATION), this.expiration.attributes().attribute(RocksDBExpirationConfiguration.EXPIRED_LOCATION)});
        super.validate(globalConfig);
    }

    public RocksDBStoreConfiguration create() {
        return new RocksDBStoreConfiguration(this.attributes.protect(), this.async.create(), this.expiration.create());
    }

    public Builder<?> read(RocksDBStoreConfiguration template, Combine combine) {
        super.read((StoreConfiguration)template, combine);
        this.expiration.read(template.expiration(), combine);
        return this.self();
    }

    public RocksDBStoreConfigurationBuilder self() {
        return this;
    }
}

