/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rocksdb.configuration;

import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.serializing.AbstractStoreSerializer;
import org.infinispan.configuration.serializing.ConfigurationSerializer;
import org.infinispan.persistence.rocksdb.configuration.Attribute;
import org.infinispan.persistence.rocksdb.configuration.Element;
import org.infinispan.persistence.rocksdb.configuration.RocksDBExpirationConfiguration;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfiguration;

public class RocksDBStoreConfigurationSerializer
extends AbstractStoreSerializer
implements ConfigurationSerializer<RocksDBStoreConfiguration> {
    public void serialize(ConfigurationWriter writer, RocksDBStoreConfiguration configuration) {
        RocksDBExpirationConfiguration expiration;
        AttributeSet expirationAttrs;
        AttributeSet attributes = configuration.attributes();
        writer.writeStartElement((Enum)Element.ROCKSDB_STORE);
        writer.writeDefaultNamespace("urn:infinispan:config:store:rocksdb:" + Version.getMajorMinor());
        configuration.attributes().write(writer);
        this.writeCommonStoreSubAttributes(writer, configuration);
        if (attributes.attribute(RocksDBStoreConfiguration.COMPRESSION_TYPE).isModified()) {
            writer.writeStartElement((Enum)Element.COMPRESSION);
            attributes.write(writer, RocksDBStoreConfiguration.COMPRESSION_TYPE, (Enum)Attribute.TYPE);
            writer.writeEndElement();
        }
        if ((expirationAttrs = (expiration = configuration.expiration()).attributes()).attribute(RocksDBExpirationConfiguration.EXPIRED_LOCATION).isModified()) {
            writer.writeStartElement((Enum)Element.EXPIRATION);
            expirationAttrs.write(writer, RocksDBExpirationConfiguration.EXPIRED_LOCATION, (Enum)Attribute.PATH);
            writer.writeEndElement();
        }
        this.writeCommonStoreElements(writer, (StoreConfiguration)configuration);
        writer.writeEndElement();
    }
}

