/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.upgrade;

import java.io.IOException;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfiguration;
import org.infinispan.persistence.remote.upgrade.SerializationUtils;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=6400)
public class AddSourceRemoteStoreTask
implements Function<EmbeddedCacheManager, Void> {
    private final String cacheName;
    private final RemoteStoreConfiguration storeConfiguration;

    public AddSourceRemoteStoreTask(String cacheName, RemoteStoreConfiguration storeConfiguration) {
        this.cacheName = cacheName;
        this.storeConfiguration = storeConfiguration;
    }

    @ProtoFactory
    public AddSourceRemoteStoreTask(String cacheName, String configJson) {
        this.cacheName = cacheName;
        try {
            this.storeConfiguration = SerializationUtils.fromJson(configJson);
        }
        catch (IOException e) {
            throw new MarshallingException("Unable to parse configuration json", (Throwable)e);
        }
    }

    @ProtoField(value=1)
    String getCacheName() {
        return this.cacheName;
    }

    @ProtoField(value=2)
    String getConfigJson() {
        return SerializationUtils.toJson(this.storeConfiguration);
    }

    @Override
    public Void apply(EmbeddedCacheManager embeddedCacheManager) {
        ComponentRegistry cr = ComponentRegistry.of((Cache)embeddedCacheManager.getCache(this.cacheName));
        PersistenceManager persistenceManager = (PersistenceManager)cr.getComponent(PersistenceManager.class);
        try {
            if (persistenceManager.getStores(RemoteStore.class).isEmpty()) {
                return (Void)CompletionStages.join((CompletionStage)persistenceManager.addStore((StoreConfiguration)this.storeConfiguration));
            }
            return null;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }
}

