/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.persistence.remote.configuration.ConnectionPoolConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.ExecutorFactoryConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.RemoteServerConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteServerConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationChildBuilder;
import org.infinispan.persistence.remote.configuration.SecurityConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.global.RemoteContainersConfiguration;
import org.infinispan.persistence.remote.logging.Log;

public class RemoteStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<RemoteStoreConfiguration, RemoteStoreConfigurationBuilder>
implements RemoteStoreConfigurationChildBuilder<RemoteStoreConfigurationBuilder> {
    private final ExecutorFactoryConfigurationBuilder asyncExecutorFactory;
    private final ConnectionPoolConfigurationBuilder connectionPool;
    private final SecurityConfigurationBuilder security;
    private final List<RemoteServerConfigurationBuilder> servers = new ArrayList<RemoteServerConfigurationBuilder>();

    public RemoteStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder, RemoteStoreConfiguration.attributeDefinitionSet());
        this.asyncExecutorFactory = new ExecutorFactoryConfigurationBuilder(this);
        this.connectionPool = new ConnectionPoolConfigurationBuilder(this);
        this.security = new SecurityConfigurationBuilder(this);
    }

    public RemoteStoreConfigurationBuilder self() {
        return this;
    }

    @Override
    public ExecutorFactoryConfigurationBuilder asyncExecutorFactory() {
        return this.asyncExecutorFactory;
    }

    @Override
    public RemoteStoreConfigurationBuilder balancingStrategy(String balancingStrategy) {
        this.attributes.attribute(RemoteStoreConfiguration.BALANCING_STRATEGY).set((Object)balancingStrategy);
        return this;
    }

    @Override
    public ConnectionPoolConfigurationBuilder connectionPool() {
        return this.connectionPool;
    }

    @Override
    public RemoteStoreConfigurationBuilder connectionTimeout(long connectionTimeout) {
        this.attributes.attribute(RemoteStoreConfiguration.CONNECTION_TIMEOUT).set((Object)connectionTimeout);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder forceReturnValues(boolean forceReturnValues) {
        this.attributes.attribute(RemoteStoreConfiguration.FORCE_RETURN_VALUES).set((Object)forceReturnValues);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder marshaller(String marshaller) {
        this.attributes.attribute(RemoteStoreConfiguration.MARSHALLER).set((Object)marshaller);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder marshaller(Class<? extends Marshaller> marshaller) {
        this.marshaller(marshaller.getName());
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder protocolVersion(ProtocolVersion protocolVersion) {
        this.attributes.attribute(RemoteStoreConfiguration.PROTOCOL_VERSION).set((Object)protocolVersion);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder remoteCacheContainer(String name) {
        this.attributes.attribute(RemoteStoreConfiguration.REMOTE_CACHE_CONTAINER).set((Object)name);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder remoteCacheName(String remoteCacheName) {
        this.attributes.attribute(RemoteStoreConfiguration.REMOTE_CACHE_NAME).set((Object)remoteCacheName);
        return this;
    }

    public RemoteStoreConfigurationBuilder uri(String uri) {
        this.attributes.attribute(RemoteStoreConfiguration.URI).set((Object)uri);
        return this;
    }

    @Override
    public SecurityConfigurationBuilder remoteSecurity() {
        return this.security;
    }

    @Override
    public RemoteStoreConfigurationBuilder socketTimeout(long socketTimeout) {
        this.attributes.attribute(RemoteStoreConfiguration.SOCKET_TIMEOUT).set((Object)socketTimeout);
        return this;
    }

    @Override
    public RemoteStoreConfigurationBuilder tcpNoDelay(boolean tcpNoDelay) {
        this.attributes.attribute(RemoteStoreConfiguration.TCP_NO_DELAY).set((Object)tcpNoDelay);
        return this;
    }

    @Override
    public RemoteServerConfigurationBuilder addServer() {
        RemoteServerConfigurationBuilder builder = new RemoteServerConfigurationBuilder(this);
        this.servers.add(builder);
        return builder;
    }

    public RemoteStoreConfiguration create() {
        ArrayList<RemoteServerConfiguration> remoteServers = new ArrayList<RemoteServerConfiguration>();
        for (RemoteServerConfigurationBuilder server : this.servers) {
            remoteServers.add(server.create());
        }
        return new RemoteStoreConfiguration(this.attributes.protect(), this.async.create(), this.asyncExecutorFactory.create(), this.connectionPool.create(), this.security.create(), remoteServers);
    }

    public RemoteStoreConfigurationBuilder read(RemoteStoreConfiguration template, Combine combine) {
        super.read((StoreConfiguration)template, combine);
        this.asyncExecutorFactory.read(template.asyncExecutorFactory(), combine);
        this.connectionPool.read(template.connectionPool(), combine);
        for (RemoteServerConfiguration server : template.servers()) {
            this.addServer().host(server.host()).port(server.port());
        }
        this.security.read(template.security(), combine);
        return this;
    }

    public RemoteStoreConfigurationBuilder withProperties(Properties props) {
        String version = (String)props.remove(RemoteStoreConfiguration.PROTOCOL_VERSION.name());
        if (version != null) {
            this.protocolVersion(ProtocolVersion.parseVersion((String)version));
        }
        return (RemoteStoreConfigurationBuilder)super.withProperties(props);
    }

    public void validate(GlobalConfiguration globalConfig) {
        if (this.attributes.attribute(RemoteStoreConfiguration.URI).isNull() && this.servers.isEmpty() && !this.uriPropertyDefined()) {
            String containerName = (String)this.attributes.attribute(RemoteStoreConfiguration.REMOTE_CACHE_CONTAINER).get();
            RemoteContainersConfiguration remoteContainersConfig = (RemoteContainersConfiguration)globalConfig.module(RemoteContainersConfiguration.class);
            if (remoteContainersConfig == null || !remoteContainersConfig.configurations().containsKey(containerName)) {
                throw Log.CONFIG.remoteStoreWithoutContainer();
            }
        }
        super.validate(globalConfig);
    }

    private boolean uriPropertyDefined() {
        return TypedProperties.toTypedProperties((Map)((Map)this.attributes.attribute(AbstractStoreConfiguration.PROPERTIES).get())).containsKey((Object)"infinispan.client.hotrod.uri");
    }

    public void validate() {
        this.connectionPool.validate();
        this.asyncExecutorFactory.validate();
        for (RemoteServerConfigurationBuilder server : this.servers) {
            server.validate();
        }
        if (((Boolean)this.attributes.attribute(AbstractStoreConfiguration.SEGMENTED).get()).booleanValue() && this.builder.clustering().hash().groups().isEnabled()) {
            throw Log.CONFIG.segmentationNotSupportedWithGroups();
        }
    }
}

