/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.CacheParser;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser;
import org.infinispan.persistence.remote.configuration.Attribute;
import org.infinispan.persistence.remote.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.ConnectionPoolConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.Element;
import org.infinispan.persistence.remote.configuration.ExecutorFactoryConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.ExhaustedAction;
import org.infinispan.persistence.remote.configuration.RemoteServerConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.SecurityConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.SslConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.global.RemoteContainerConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.global.RemoteContainersConfigurationBuilder;

@Namespaces(value={@Namespace(root="remote-store"), @Namespace(root="remote-cache-containers"), @Namespace(uri="urn:infinispan:config:store:remote:*", root="remote-store"), @Namespace(uri="urn:infinispan:config:store:remote:*", root="remote-cache-containers")})
public class RemoteStoreConfigurationParser
implements ConfigurationParser {
    public static final String PREFIX = "store:remote";
    public static final String NAMESPACE = "urn:infinispan:config:store:remote:";

    public void readElement(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case REMOTE_STORE: {
                this.parseRemoteStore(reader, builder.persistence(), holder.getClassLoader());
                break;
            }
            case REMOTE_CACHE_CONTAINERS: {
                this.parseRemoteContainers(reader, holder);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
            }
        }
    }

    private void parseRemoteContainers(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        block3: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case REMOTE_CACHE_CONTAINER: {
                    this.parseRemoteContainer(reader, holder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
        }
    }

    private void parseRemoteContainer(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        RemoteContainersConfigurationBuilder containersBuilder = (RemoteContainersConfigurationBuilder)holder.getGlobalConfigurationBuilder().addModule(RemoteContainersConfigurationBuilder.class);
        String name = reader.getAttributeValue((Enum)Attribute.NAME);
        RemoteContainerConfigurationBuilder builder = containersBuilder.addRemoteContainer(name != null ? name : "");
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    continue block4;
                }
                case URI: {
                    builder.uri(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        ParseUtils.parseAttributes((ConfigurationReader)reader, (Builder)builder);
        builder.properties(Parser.parseProperties((ConfigurationReader)reader, (Enum)Element.REMOTE_CACHE_CONTAINER));
    }

    private void parseRemoteStore(ConfigurationReader reader, PersistenceConfigurationBuilder persistenceBuilder, ClassLoader classLoader) {
        RemoteStoreConfigurationBuilder builder = new RemoteStoreConfigurationBuilder(persistenceBuilder);
        this.parseRemoteStoreAttributes(reader, builder);
        block6: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ASYNC_TRANSPORT_EXECUTOR: {
                    this.parseAsyncTransportExecutor(reader, builder.asyncExecutorFactory(), classLoader);
                    continue block6;
                }
                case CONNECTION_POOL: {
                    this.parseConnectionPool(reader, builder.connectionPool());
                    continue block6;
                }
                case REMOTE_SERVER: {
                    if (reader.getAttributeCount() > 0) {
                        this.parseServer(reader, builder.addServer());
                        continue block6;
                    }
                    while (reader.inTag((Enum)Element.REMOTE_SERVER)) {
                        this.parseServer(reader, builder.addServer());
                    }
                    continue block6;
                }
                case SECURITY: {
                    this.parseSecurity(reader, builder.remoteSecurity());
                    continue block6;
                }
            }
            CacheParser.parseStoreElement((ConfigurationReader)reader, (StoreConfigurationBuilder)builder);
        }
        persistenceBuilder.addStore((StoreConfigurationBuilder)builder);
    }

    private void parseSecurity(ConfigurationReader reader, SecurityConfigurationBuilder security) {
        block4: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHENTICATION: {
                    this.parseAuthentication(reader, security.authentication());
                    continue block4;
                }
                case ENCRYPTION: {
                    this.parseEncryption(reader, security.ssl());
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
        }
    }

    private void parseAuthentication(ConfigurationReader reader, AuthenticationConfigurationBuilder authentication) {
        authentication.enable();
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case SERVER_NAME: {
                    authentication.serverName(value);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        boolean hasMech = false;
        block9: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTH_PLAIN: {
                    if (hasMech) {
                        throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
                    }
                    this.parseAuthenticationPlain(reader, authentication);
                    hasMech = true;
                    continue block9;
                }
                case AUTH_DIGEST: {
                    if (hasMech) {
                        throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
                    }
                    this.parseAuthenticationDigest(reader, authentication);
                    hasMech = true;
                    continue block9;
                }
                case AUTH_EXTERNAL: {
                    if (hasMech) {
                        throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
                    }
                    this.parseAuthenticationExternal(reader, authentication);
                    hasMech = true;
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
        }
    }

    private void parseAuthenticationPlain(ConfigurationReader reader, AuthenticationConfigurationBuilder authentication) {
        String[] attributes = ParseUtils.requireAttributes((ConfigurationReader)reader, (String[])new String[]{Attribute.USERNAME.getLocalName(), Attribute.PASSWORD.getLocalName()});
        authentication.saslMechanism("PLAIN").username(attributes[0]).password(attributes[1]);
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    private void parseAuthenticationDigest(ConfigurationReader reader, AuthenticationConfigurationBuilder authentication) {
        String[] attributes = ParseUtils.requireAttributes((ConfigurationReader)reader, (String[])new String[]{Attribute.USERNAME.getLocalName(), Attribute.PASSWORD.getLocalName(), Attribute.REALM.getLocalName()});
        authentication.saslMechanism("DIGEST-MD5").username(attributes[0]).password(attributes[1]).realm(attributes[2]);
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    private void parseAuthenticationExternal(ConfigurationReader reader, AuthenticationConfigurationBuilder authentication) {
        ParseUtils.requireNoAttributes((ConfigurationReader)reader);
        authentication.saslMechanism("EXTERNAL");
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    private void parseEncryption(ConfigurationReader reader, SslConfigurationBuilder ssl) {
        ssl.enable();
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case PROTOCOL: {
                    ssl.protocol(value);
                    continue block8;
                }
                case SNI_HOSTNAME: {
                    ssl.sniHostName(value);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        block9: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case KEYSTORE: {
                    this.parseKeystore(reader, ssl);
                    continue block9;
                }
                case TRUSTSTORE: {
                    this.parseTruststore(reader, ssl);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
        }
    }

    private void parseKeystore(ConfigurationReader reader, SslConfigurationBuilder ssl) {
        String[] attributes = ParseUtils.requireAttributes((ConfigurationReader)reader, (boolean)true, (String[])new String[]{Attribute.FILENAME.getLocalName(), Attribute.PASSWORD.getLocalName()});
        ssl.keyStoreFileName(attributes[0]);
        ssl.keyStorePassword(attributes[1].toCharArray());
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case FILENAME: 
                case PASSWORD: {
                    continue block5;
                }
                case KEY_ALIAS: {
                    ssl.keyAlias(value);
                    continue block5;
                }
                case TYPE: {
                    ssl.keyStoreType(value);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    private void parseTruststore(ConfigurationReader reader, SslConfigurationBuilder ssl) {
        String[] attributes = ParseUtils.requireAttributes((ConfigurationReader)reader, (boolean)true, (String[])new String[]{Attribute.FILENAME.getLocalName(), Attribute.TYPE.getLocalName()});
        ssl.trustStoreFileName(attributes[0]);
        ssl.trustStorePassword(attributes[1].toCharArray());
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case FILENAME: 
                case PASSWORD: {
                    ssl.trustStorePassword(value.toCharArray());
                    continue block4;
                }
                case TYPE: {
                    ssl.trustStoreType(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    private void parseAsyncTransportExecutor(ConfigurationReader reader, ExecutorFactoryConfigurationBuilder builder, ClassLoader classLoader) {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case FACTORY: {
                    builder.factory((ExecutorFactory)Util.getInstance((String)value, (ClassLoader)classLoader));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        builder.withExecutorProperties(Parser.parseProperties((ConfigurationReader)reader, (Enum)Element.ASYNC_TRANSPORT_EXECUTOR));
    }

    private void parseConnectionPool(ConfigurationReader reader, ConnectionPoolConfigurationBuilder builder) {
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case EXHAUSTED_ACTION: {
                    builder.exhaustedAction(ExhaustedAction.valueOf(value));
                    continue block9;
                }
                case MAX_ACTIVE: {
                    builder.maxActive(Integer.parseInt(value));
                    continue block9;
                }
                case MAX_PENDING_REQUESTS: {
                    builder.maxPendingRequests(Integer.parseInt(value));
                    continue block9;
                }
                case MIN_EVICTABLE_IDLE_TIME: {
                    builder.minEvictableIdleTime(Long.parseLong(value));
                    continue block9;
                }
                case MIN_IDLE: {
                    builder.minIdle(Integer.parseInt(value));
                    continue block9;
                }
                case MAX_WAIT: {
                    builder.maxWait(Integer.parseInt(value));
                    continue block9;
                }
                case MAX_TOTAL: 
                case TEST_WHILE_IDLE: 
                case TIME_BETWEEN_EVICTION_RUNS: {
                    if (reader.getSchema().since(10, 0)) {
                        throw ParseUtils.attributeRemoved((ConfigurationReader)reader, (int)i);
                    }
                    ParseUtils.ignoreAttribute((ConfigurationReader)reader, (int)i);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    private void parseServer(ConfigurationReader reader, RemoteServerConfigurationBuilder builder) {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case HOST: {
                    builder.host(value);
                    continue block5;
                }
                case PORT: {
                    builder.port(Integer.parseInt(value));
                    continue block5;
                }
                case OUTBOUND_SOCKET_BINDING: {
                    ParseUtils.ignoreAttribute((ConfigurationReader)reader, (int)i);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    private void parseRemoteStoreAttributes(ConfigurationReader reader, RemoteStoreConfigurationBuilder builder) {
        block14: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            String attrName = reader.getAttributeName(i);
            Attribute attribute = Attribute.forName(attrName);
            switch (attribute) {
                case BALANCING_STRATEGY: {
                    builder.balancingStrategy(value);
                    continue block14;
                }
                case CONNECT_TIMEOUT: {
                    builder.connectionTimeout(Long.parseLong(value));
                    continue block14;
                }
                case FORCE_RETURN_VALUES: {
                    builder.forceReturnValues(Boolean.parseBoolean(value));
                    continue block14;
                }
                case KEY_SIZE_ESTIMATE: 
                case VALUE_SIZE_ESTIMATE: 
                case HOTROD_WRAPPING: 
                case RAW_VALUES: {
                    if (reader.getSchema().since(16, 0)) {
                        throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                    }
                    ParseUtils.ignoreAttribute((ConfigurationReader)reader, (int)i);
                    continue block14;
                }
                case MARSHALLER: {
                    builder.marshaller(value);
                    continue block14;
                }
                case PING_ON_STARTUP: {
                    if (!reader.getSchema().since(9, 1)) {
                        throw ParseUtils.attributeRemoved((ConfigurationReader)reader, (int)i);
                    }
                    ParseUtils.ignoreAttribute((ConfigurationReader)reader, (int)i);
                    continue block14;
                }
                case PROTOCOL_VERSION: {
                    builder.protocolVersion(ProtocolVersion.parseVersion((String)value));
                    continue block14;
                }
                case REMOTE_CACHE_CONTAINER: {
                    builder.remoteCacheContainer(value);
                    continue block14;
                }
                case REMOTE_CACHE_NAME: {
                    builder.remoteCacheName(value);
                    continue block14;
                }
                case SOCKET_TIMEOUT: {
                    builder.socketTimeout(Long.parseLong(value));
                    continue block14;
                }
                case TCP_NO_DELAY: {
                    builder.tcpNoDelay(Boolean.parseBoolean(value));
                    continue block14;
                }
                case URI: {
                    builder.uri(value);
                    continue block14;
                }
                default: {
                    CacheParser.parseStoreAttribute((ConfigurationReader)reader, (int)i, (AbstractStoreConfigurationBuilder)builder);
                }
            }
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }
}

