/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.upgrade;

import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.persistence.remote.logging.Log;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.logging.LogFactory;

@ProtoTypeId(value=6402)
public class DisconnectRemoteStoreTask
implements Function<EmbeddedCacheManager, Void> {
    private static final Log log = (Log)LogFactory.getLog(DisconnectRemoteStoreTask.class, Log.class);
    @ProtoField(value=1)
    final String cacheName;

    @ProtoFactory
    public DisconnectRemoteStoreTask(String cacheName) {
        this.cacheName = cacheName;
    }

    @Override
    public Void apply(EmbeddedCacheManager embeddedCacheManager) {
        PersistenceManager persistenceManager = (PersistenceManager)ComponentRegistry.componentOf((Cache)embeddedCacheManager.getCache(this.cacheName), PersistenceManager.class);
        try {
            log.debugf("Disconnecting source for cache {}", this.cacheName);
            return (Void)CompletionStages.join((CompletionStage)persistenceManager.disableStore(RemoteStore.class.getName()));
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }
}

