/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.common.impl.connectionfactory;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import io.agroal.api.configuration.supplier.AgroalDataSourceConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalPropertiesReader;
import io.agroal.api.security.NamePrincipal;
import io.agroal.api.security.SimplePassword;
import java.security.Principal;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.util.function.Supplier;
import org.infinispan.commons.util.Util;
import org.infinispan.persistence.jdbc.common.JdbcUtil;
import org.infinispan.persistence.jdbc.common.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.PooledConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.common.logging.Log;
import org.infinispan.persistence.spi.PersistenceException;

public class PooledConnectionFactory
extends ConnectionFactory {
    private static final String PROPERTIES_PREFIX = "org.infinispan.agroal.";
    private static final Log log = Log.getLog(PooledConnectionFactory.class);
    private AgroalDataSource dataSource;

    @Override
    public void start(ConnectionFactoryConfiguration config, ClassLoader classLoader) throws PersistenceException {
        if (!(config instanceof PooledConnectionFactoryConfiguration)) {
            throw new PersistenceException("ConnectionFactoryConfiguration passed in must be an instance of PooledConnectionFactoryConfiguration");
        }
        PooledConnectionFactoryConfiguration poolConfig = (PooledConnectionFactoryConfiguration)config;
        try {
            String propsFile = poolConfig.propertyFile();
            if (propsFile != null) {
                this.dataSource = AgroalDataSource.from((Supplier)new AgroalPropertiesReader(PROPERTIES_PREFIX).readProperties(propsFile), (AgroalDataSourceListener[])new AgroalDataSourceListener[0]);
            } else {
                Class driverClass = Util.loadClass((String)poolConfig.driverClass(), null);
                String password = poolConfig.password() != null ? poolConfig.password() : "";
                AgroalDataSourceConfigurationSupplier configuration = new AgroalDataSourceConfigurationSupplier().connectionPoolConfiguration(cp -> cp.maxSize(10).acquisitionTimeout(Duration.ofSeconds(30L)).validationTimeout(Duration.ofSeconds(5L)).leakTimeout(Duration.ofSeconds(60L)).connectionValidator(AgroalConnectionPoolConfiguration.ConnectionValidator.defaultValidator()).connectionFactoryConfiguration(cf -> cf.jdbcUrl(poolConfig.connectionUrl()).connectionProviderClass(driverClass).jdbcTransactionIsolation(AgroalConnectionFactoryConfiguration.TransactionIsolation.UNDEFINED).principal((Principal)new NamePrincipal(poolConfig.username())).credential((Object)new SimplePassword(password))));
                this.dataSource = AgroalDataSource.from((Supplier)configuration, (AgroalDataSourceListener[])new AgroalDataSourceListener[0]);
            }
        }
        catch (Exception e) {
            throw new PersistenceException("Failed to create a AgroalDataSource", (Throwable)e);
        }
    }

    @Override
    public void stop() {
        if (this.dataSource != null) {
            this.dataSource.close();
            if (log.isTraceEnabled()) {
                log.debug("Successfully stopped PooledConnectionFactory.");
            }
        }
    }

    @Override
    public Connection getConnection() throws PersistenceException {
        try {
            Connection connection = this.dataSource.getConnection();
            this.log(connection, true);
            return connection;
        }
        catch (SQLException e) {
            throw new PersistenceException("Failed obtaining connection from PooledDataSource", (Throwable)e);
        }
    }

    @Override
    public void releaseConnection(Connection conn) {
        this.log(conn, false);
        JdbcUtil.safeClose(conn);
    }

    public int getMaxPoolSize() {
        return this.dataSource.getConfiguration().connectionPoolConfiguration().maxSize();
    }

    public long getActiveConnections() {
        return this.dataSource.getMetrics().activeCount();
    }

    private void log(Connection connection, boolean checkout) {
        if (log.isTraceEnabled()) {
            String operation = checkout ? "checkout" : "release";
            log.tracef("Connection %s (active=%d): %s", operation, this.getActiveConnections(), connection);
        }
    }
}

