/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.common.impl.connectionfactory;

import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.persistence.jdbc.common.configuration.CDIConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.common.logging.Log;
import org.infinispan.persistence.spi.PersistenceException;

public class CDIConnectionFactory
extends ConnectionFactory {
    private static final Log log = Log.getLog(CDIConnectionFactory.class);
    private CDIConnectionFactoryConfiguration managedConfiguration;
    private volatile DataSource dataSource;

    @Override
    public void start(ConnectionFactoryConfiguration factoryConfiguration, ClassLoader classLoader) throws PersistenceException {
        this.managedConfiguration = (CDIConnectionFactoryConfiguration)factoryConfiguration;
    }

    private void initDataSource() {
        try {
            String datasourceName = this.managedConfiguration.name();
            if (datasourceName == null) {
                this.dataSource = (DataSource)CDI.current().select(DataSource.class, new Annotation[0]).get();
            } else {
                Class annotationClass = ReflectionUtil.getClassForName((String)this.managedConfiguration.annotation(), (ClassLoader)Thread.currentThread().getContextClassLoader());
                Annotation annotation = (Annotation)Util.newInstanceOrNull((Class)annotationClass, (Class[])new Class[]{String.class}, (Object[])new Object[]{datasourceName});
                this.dataSource = (DataSource)CDI.current().select(DataSource.class, new Annotation[]{annotation}).get();
            }
            if (this.dataSource == null) {
                throw Log.PERSISTENCE.connectionNotFound("CDI", datasourceName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public Connection getConnection() throws PersistenceException {
        Connection connection;
        if (this.dataSource == null) {
            this.initDataSource();
        }
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw Log.PERSISTENCE.sqlFailureRetrievingConnection(e);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Connection checked out: %s", connection);
        }
        return connection;
    }

    @Override
    public void releaseConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            Log.PERSISTENCE.sqlFailureClosingConnection(conn, e);
        }
    }
}

