/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.common.impl;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.internal.functions.Functions;
import jakarta.transaction.Transaction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.persistence.jdbc.common.TableOperations;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfiguration;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.common.logging.Log;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.concurrent.BlockingManager;
import org.reactivestreams.Publisher;

public abstract class BaseJdbcStore<K, V, C extends AbstractJdbcStoreConfiguration>
implements NonBlockingStore<K, V> {
    protected static final Log log = Log.getLog(BaseJdbcStore.class);
    protected ConnectionFactory connectionFactory;
    protected BlockingManager blockingManager;
    protected C config;
    protected TableOperations<K, V> tableOperations;
    protected final Map<Transaction, Connection> transactionConnectionMap = new ConcurrentHashMap<Transaction, Connection>();

    public Set<NonBlockingStore.Characteristic> characteristics() {
        return EnumSet.of(NonBlockingStore.Characteristic.BULK_READ, NonBlockingStore.Characteristic.TRANSACTIONAL, NonBlockingStore.Characteristic.SHAREABLE);
    }

    Object keyIdentifier(Object key) {
        return key;
    }

    protected abstract TableOperations<K, V> createTableOperations(InitializationContext var1, C var2) throws SQLException;

    public CompletionStage<Void> start(InitializationContext ctx) {
        this.config = (AbstractJdbcStoreConfiguration)ctx.getConfiguration();
        this.blockingManager = ctx.getBlockingManager();
        return this.blockingManager.runBlocking(() -> {
            try {
                ConnectionFactory factory = ConnectionFactory.getConnectionFactory(((AbstractJdbcStoreConfiguration)((Object)((Object)this.config))).connectionFactory().connectionFactoryClass());
                factory.start(((AbstractJdbcStoreConfiguration)((Object)((Object)this.config))).connectionFactory(), factory.getClass().getClassLoader());
                this.connectionFactory = factory;
                this.tableOperations = this.createTableOperations(ctx, this.config);
            }
            catch (SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        }, (Object)"jdbcstore-start");
    }

    protected void extraStopSteps() {
    }

    public CompletionStage<Void> stop() {
        return this.blockingManager.runBlocking(() -> {
            this.extraStopSteps();
            try {
                log.tracef("Stopping connection factory: %s", this.connectionFactory);
                if (this.connectionFactory != null) {
                    this.connectionFactory.stop();
                }
            }
            catch (Throwable t) {
                log.debug("Exception while stopping", t);
            }
        }, (Object)"jdbcstore-stop");
    }

    public CompletionStage<Boolean> isAvailable() {
        return this.blockingManager.supplyBlocking(() -> {
            if (this.connectionFactory == null) {
                return false;
            }
            Connection connection = null;
            try {
                connection = this.connectionFactory.getConnection();
                Boolean bl = connection != null && connection.isValid(10);
                return bl;
            }
            catch (Throwable t) {
                log.debugf(t, "Exception thrown when checking DB availability", new Object[0]);
                throw CompletableFutures.asCompletionException((Throwable)t);
            }
            finally {
                this.connectionFactory.releaseConnection(connection);
            }
        }, (Object)"jdbcstore-available");
    }

    public CompletionStage<MarshallableEntry<K, V>> load(int segment, Object key) {
        return this.blockingManager.supplyBlocking(() -> {
            Connection conn = null;
            try {
                conn = this.connectionFactory.getConnection();
                MarshallableEntry<K, V> marshallableEntry = this.tableOperations.loadEntry(conn, segment, key);
                return marshallableEntry;
            }
            catch (SQLException e) {
                Object keyIdentifier = this.keyIdentifier(key);
                Log.PERSISTENCE.sqlFailureReadingKey(key, keyIdentifier, e);
                throw new PersistenceException(String.format("SQL error while fetching stored entry with key: %s, lockingKey: %s", key, keyIdentifier), (Throwable)e);
            }
            finally {
                this.connectionFactory.releaseConnection(conn);
            }
        }, (Object)"jdbcstore-load");
    }

    public CompletionStage<Void> write(int segment, MarshallableEntry<? extends K, ? extends V> entry) {
        return this.blockingManager.runBlocking(() -> {
            Connection connection = null;
            try {
                connection = this.connectionFactory.getConnection();
                this.tableOperations.upsertEntry(connection, segment, entry);
            }
            catch (SQLException ex) {
                Log.PERSISTENCE.sqlFailureStoringKey(entry.getKey(), ex);
                throw new PersistenceException(String.format("Error while storing string key to database; key: '%s'", entry.getKey()), (Throwable)ex);
            }
            finally {
                this.connectionFactory.releaseConnection(connection);
            }
        }, (Object)"jdbcstore-write");
    }

    public CompletionStage<Boolean> delete(int segment, Object key) {
        return this.blockingManager.supplyBlocking(() -> {
            Connection connection = null;
            try {
                connection = this.connectionFactory.getConnection();
                Boolean bl = this.tableOperations.deleteEntry(connection, segment, key);
                return bl;
            }
            catch (SQLException ex) {
                Log.PERSISTENCE.sqlFailureRemovingKeys(ex);
                throw new PersistenceException(String.format("Error while removing key %s from database", key), (Throwable)ex);
            }
            finally {
                this.connectionFactory.releaseConnection(connection);
            }
        }, (Object)"jdbcstore-delete");
    }

    public CompletionStage<Void> clear() {
        return this.blockingManager.runBlocking(() -> {
            Connection connection = null;
            try {
                connection = this.connectionFactory.getConnection();
                this.tableOperations.deleteAllRows(connection);
            }
            catch (SQLException ex) {
                Log.PERSISTENCE.failedClearingJdbcCacheStore(ex);
                throw new PersistenceException("Failed clearing cache store", (Throwable)ex);
            }
            finally {
                this.connectionFactory.releaseConnection(connection);
            }
        }, (Object)"jdbcstore-delete");
    }

    public CompletionStage<Void> batch(int publisherCount, Publisher<NonBlockingStore.SegmentedPublisher<Object>> removePublisher, Publisher<NonBlockingStore.SegmentedPublisher<MarshallableEntry<K, V>>> writePublisher) {
        return this.blockingManager.runBlocking(() -> {
            Connection connection = null;
            try {
                connection = this.connectionFactory.getConnection();
                this.tableOperations.batchUpdates(connection, publisherCount, (Publisher<Object>)Flowable.fromPublisher((Publisher)removePublisher).concatMapEager(Functions.identity(), publisherCount, publisherCount), writePublisher);
            }
            catch (SQLException e) {
                throw Log.PERSISTENCE.sqlFailureWritingBatch(e);
            }
            finally {
                this.connectionFactory.releaseConnection(connection);
            }
        }, (Object)"jdbcstore-batch");
    }

    public CompletionStage<Void> prepareWithModifications(Transaction tx, int publisherCount, Publisher<NonBlockingStore.SegmentedPublisher<Object>> removePublisher, Publisher<NonBlockingStore.SegmentedPublisher<MarshallableEntry<K, V>>> writePublisher) {
        return this.blockingManager.runBlocking(() -> {
            try {
                Connection connection = this.getTxConnection(tx);
                connection.setAutoCommit(false);
                this.tableOperations.batchUpdates(connection, publisherCount, (Publisher<Object>)Flowable.fromPublisher((Publisher)removePublisher).concatMapEager(Functions.identity(), publisherCount, publisherCount), writePublisher);
            }
            catch (SQLException e) {
                throw Log.PERSISTENCE.prepareTxFailure(e);
            }
        }, (Object)"jdbcstore-prepare");
    }

    public CompletionStage<Void> commit(Transaction tx) {
        return this.blockingManager.runBlocking(() -> {
            try {
                Connection connection = this.getTxConnection(tx);
                connection.commit();
            }
            catch (SQLException e) {
                Log.PERSISTENCE.sqlFailureTxCommit(e);
                throw new PersistenceException(String.format("Error during commit of JDBC transaction (%s)", tx), (Throwable)e);
            }
            finally {
                this.destroyTxConnection(tx);
            }
        }, (Object)"jdbcstore-commit");
    }

    public CompletionStage<Void> rollback(Transaction tx) {
        return this.blockingManager.runBlocking(() -> {
            try {
                Connection connection = this.getTxConnection(tx);
                connection.rollback();
            }
            catch (SQLException e) {
                Log.PERSISTENCE.sqlFailureTxRollback(e);
                throw new PersistenceException(String.format("Error during rollback of JDBC transaction (%s)", tx), (Throwable)e);
            }
            finally {
                this.destroyTxConnection(tx);
            }
        }, (Object)"jdbcstore-rollback");
    }

    protected Connection getTxConnection(Transaction tx) {
        Connection connection = this.transactionConnectionMap.get(tx);
        if (connection == null) {
            connection = this.connectionFactory.getConnection();
            this.transactionConnectionMap.put(tx, connection);
        }
        return connection;
    }

    protected void destroyTxConnection(Transaction tx) {
        Connection connection = this.transactionConnectionMap.remove(tx);
        if (connection != null) {
            this.connectionFactory.releaseConnection(connection);
        }
    }

    public Publisher<MarshallableEntry<K, V>> publishEntries(IntSet segments, Predicate<? super K> filter, boolean includeValues) {
        return this.blockingManager.blockingPublisher(this.tableOperations.publishEntries(this.connectionFactory::getConnection, this.connectionFactory::releaseConnection, segments, filter, includeValues));
    }

    public Publisher<K> publishKeys(IntSet segments, Predicate<? super K> filter) {
        return this.blockingManager.blockingPublisher(this.tableOperations.publishKeys(this.connectionFactory::getConnection, this.connectionFactory::releaseConnection, segments, filter));
    }

    public CompletionStage<Long> size(IntSet segments) {
        return this.blockingManager.supplyBlocking(() -> {
            Connection conn = null;
            try {
                conn = this.connectionFactory.getConnection();
                Long l = this.tableOperations.size(conn);
                return l;
            }
            catch (SQLException e) {
                Log.PERSISTENCE.sqlFailureSize(e);
                throw new PersistenceException("SQL failure while retrieving size", (Throwable)e);
            }
            finally {
                this.connectionFactory.releaseConnection(conn);
            }
        }, (Object)"jdbcstore-size");
    }

    public CompletionStage<Long> approximateSize(IntSet segments) {
        return this.size(segments);
    }
}

