/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.common.impl.connectionfactory;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.infinispan.persistence.jdbc.common.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.ManagedConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.common.logging.Log;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.logging.LogFactory;

public class ManagedConnectionFactory
extends ConnectionFactory {
    private static final Log log = (Log)LogFactory.getLog(ManagedConnectionFactory.class, Log.class);
    private ManagedConnectionFactoryConfiguration managedConfiguration;
    private volatile DataSource dataSource;

    @Override
    public void start(ConnectionFactoryConfiguration factoryConfiguration, ClassLoader classLoader) throws PersistenceException {
        if (!(factoryConfiguration instanceof ManagedConnectionFactoryConfiguration)) {
            throw new PersistenceException("FactoryConfiguration has to be an instance of ManagedConnectionFactoryConfiguration");
        }
        this.managedConfiguration = (ManagedConnectionFactoryConfiguration)factoryConfiguration;
    }

    @Override
    public void stop() {
    }

    @Override
    public Connection getConnection() throws PersistenceException {
        Connection connection;
        if (this.dataSource == null) {
            this.initDataSource();
        }
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw Log.PERSISTENCE.sqlFailureRetrievingConnection(e);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Connection checked out: %s", connection);
        }
        return connection;
    }

    @Override
    public void releaseConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            Log.PERSISTENCE.sqlFailureClosingConnection(conn, e);
        }
    }

    private void initDataSource() {
        this.dataSource = this.managedConfiguration.dataSource();
        if (this.dataSource != null) {
            return;
        }
        InitialContext ctx = null;
        String datasourceName = this.managedConfiguration.jndiUrl();
        try {
            ctx = new InitialContext();
            this.dataSource = (DataSource)ctx.lookup(datasourceName);
            if (log.isTraceEnabled()) {
                log.tracef("Datasource lookup for %s succeeded: %b", datasourceName, this.dataSource);
            }
            if (this.dataSource == null) {
                throw Log.PERSISTENCE.connectionNotFound("JNDI", datasourceName);
            }
        }
        catch (NamingException e) {
            throw Log.PERSISTENCE.namingExceptionLookingUpConnection(datasourceName, e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    Log.PERSISTENCE.failedClosingNamingCtx(e);
                }
            }
        }
    }
}

