/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.common.configuration;

import javax.sql.DataSource;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfigurationChildBuilder;
import org.infinispan.persistence.jdbc.common.configuration.ConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.configuration.ManagedConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.logging.Log;

public class ManagedConnectionFactoryConfigurationBuilder<S extends AbstractJdbcStoreConfigurationBuilder<?, S>>
extends AbstractJdbcStoreConfigurationChildBuilder<S>
implements ConnectionFactoryConfigurationBuilder<ManagedConnectionFactoryConfiguration> {
    private final AttributeSet attributes = ManagedConnectionFactoryConfiguration.attributeSet();

    public ManagedConnectionFactoryConfigurationBuilder(AbstractJdbcStoreConfigurationBuilder<?, S> builder) {
        super(builder);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ManagedConnectionFactoryConfigurationBuilder<S> jndiUrl(String jndiUrl) {
        this.attributes.attribute(ManagedConnectionFactoryConfiguration.JNDI_URL).set((Object)jndiUrl);
        return this;
    }

    public ManagedConnectionFactoryConfigurationBuilder<S> dataSource(DataSource dataSource) {
        this.attributes.attribute(ManagedConnectionFactoryConfiguration.DATA_SOURCE).set((Object)dataSource);
        return this;
    }

    public void validate() {
        String jndiUrl = (String)this.attributes.attribute(ManagedConnectionFactoryConfiguration.JNDI_URL).get();
        DataSource dataSource = (DataSource)this.attributes.attribute(ManagedConnectionFactoryConfiguration.DATA_SOURCE).get();
        if (jndiUrl == null && dataSource == null) {
            throw Log.CONFIG.jndiUrlOrDataSourceRequired();
        }
        if (jndiUrl != null && dataSource != null) {
            throw Log.CONFIG.jndiUrlAndDataSourceSet();
        }
    }

    public void validate(GlobalConfiguration globalConfig) {
    }

    public ManagedConnectionFactoryConfiguration create() {
        return new ManagedConnectionFactoryConfiguration(this.attributes.protect());
    }

    public ManagedConnectionFactoryConfigurationBuilder<S> read(ManagedConnectionFactoryConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }
}

