/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.common;

public enum DatabaseType {
    ACCESS,
    DB2,
    DB2_390,
    DERBY,
    FIREBIRD,
    H2,
    HSQL,
    INFORMIX,
    INTERBASE,
    MARIA_DB,
    MYSQL,
    ORACLE,
    ORACLE_XE,
    POSTGRES,
    SQLITE,
    SQL_SERVER,
    SYBASE;


    public static DatabaseType guessDialect(String name) {
        DatabaseType type = null;
        if (name == null) {
            return null;
        }
        if ((name = name.toLowerCase()).contains("mysql")) {
            type = MYSQL;
        } else if (name.contains("mariadb")) {
            type = MARIA_DB;
        } else if (name.contains("postgres") || name.contains("edb")) {
            type = POSTGRES;
        } else if (name.contains("derby")) {
            type = DERBY;
        } else if (name.contains("hsql") || name.contains("hypersonic")) {
            type = HSQL;
        } else if (name.contains("h2")) {
            type = H2;
        } else if (name.contains("sqlite")) {
            type = SQLITE;
        } else if (name.contains("db2")) {
            type = DB2;
        } else if (name.contains("informix")) {
            type = INFORMIX;
        } else if (name.contains("interbase")) {
            type = INTERBASE;
        } else if (name.contains("firebird")) {
            type = FIREBIRD;
        } else if (name.contains("sqlserver") || name.contains("microsoft") || name.contains("mssql")) {
            type = SQL_SERVER;
        } else if (name.contains("access")) {
            type = ACCESS;
        } else if (name.contains("oracle")) {
            type = ORACLE;
        } else if (name.contains("adaptive")) {
            type = SYBASE;
        }
        return type;
    }
}

