/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.common.logging;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.naming.NamingException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.persistence.jdbc.common.logging.Log;
import org.infinispan.persistence.spi.PersistenceException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void errorMarshallingObject(Throwable ioe, Object obj) {
        this.log.logf(FQCN, Logger.Level.ERROR, ioe, this.errorMarshallingObject$str(), obj);
    }

    protected String errorMarshallingObject$str() {
        return "ISPN000065: Exception while marshalling object: %s";
    }

    @Override
    public final void failedClearingJdbcCacheStore(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.failedClearingJdbcCacheStore$str(), new Object[0]);
    }

    protected String failedClearingJdbcCacheStore$str() {
        return "ISPN008001: Failed clearing cache store";
    }

    @Override
    public final void sqlFailureIntegratingState(SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureIntegratingState$str(), new Object[0]);
    }

    protected String sqlFailureIntegratingState$str() {
        return "ISPN008003: SQL failure while integrating state into store";
    }

    @Override
    public final void ioErrorUnmarshalling(IOException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.ioErrorUnmarshalling$str(), new Object[0]);
    }

    protected String ioErrorUnmarshalling$str() {
        return "ISPN008009: I/O error while unmarshalling from stream";
    }

    @Override
    public final void unexpectedClassNotFoundException(ClassNotFoundException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.unexpectedClassNotFoundException$str(), new Object[0]);
    }

    protected String unexpectedClassNotFoundException$str() {
        return "ISPN008010: *UNEXPECTED* ClassNotFoundException.";
    }

    @Override
    public final void errorCreatingTable(String sql, SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorCreatingTable$str(), (Object)sql);
    }

    protected String errorCreatingTable$str() {
        return "ISPN008011: Error while creating table; used DDL statement: '%s'";
    }

    protected String connectionNotFound$str() {
        return "ISPN008015: Could not find a connection in %s under the name '%s'";
    }

    @Override
    public final IllegalStateException connectionNotFound(String where, String dataSourceName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.connectionNotFound$str(), where, dataSourceName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    @Override
    public final void namingExceptionLookingUpConnection(String dataSourceName, NamingException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.namingExceptionLookingUpConnection$str(), (Object)dataSourceName);
    }

    protected String namingExceptionLookingUpConnection$str() {
        return "ISPN008016: Could not lookup connection with datasource %s";
    }

    @Override
    public final void failedClosingNamingCtx(NamingException e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.failedClosingNamingCtx$str(), new Object[0]);
    }

    protected String failedClosingNamingCtx$str() {
        return "ISPN008017: Failed to close naming context.";
    }

    protected String sqlFailureRetrievingConnection$str() {
        return "ISPN008018: Sql failure retrieving connection from datasource";
    }

    @Override
    public final PersistenceException sqlFailureRetrievingConnection(SQLException e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.sqlFailureRetrievingConnection$str(), new Object[0]), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void sqlFailureClosingConnection(Connection conn, SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureClosingConnection$str(), (Object)conn);
    }

    protected String sqlFailureClosingConnection$str() {
        return "ISPN008019: Issues while closing connection %s";
    }

    @Override
    public final void sqlFailureUnexpected(SQLException e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.sqlFailureUnexpected$str(), new Object[0]);
    }

    protected String sqlFailureUnexpected$str() {
        return "ISPN008022: Unexpected sql failure";
    }

    @Override
    public final void failureClosingConnection(SQLException e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.failureClosingConnection$str(), new Object[0]);
    }

    protected String failureClosingConnection$str() {
        return "ISPN008023: Failure while closing the connection to the database";
    }

    @Override
    public final void sqlFailureStoringKey(Object lockingKey, SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureStoringKey$str(), lockingKey);
    }

    protected String sqlFailureStoringKey$str() {
        return "ISPN008024: Error while storing string key to database; key: '%s'";
    }

    @Override
    public final void sqlFailureRemovingKeys(SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureRemovingKeys$str(), new Object[0]);
    }

    protected String sqlFailureRemovingKeys$str() {
        return "ISPN008025: Error while removing string keys from database";
    }

    @Override
    public final void invalidKey2StringMapper(String where, String className) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.invalidKey2StringMapper$str(), (Object)where, (Object)className);
    }

    protected String invalidKey2StringMapper$str() {
        return "ISPN008026: In order for JdbcStringBasedStore to support %s, the Key2StringMapper needs to implement TwoWayKey2StringMapper. You should either make %s implement TwoWayKey2StringMapper or disable the sql. See [https://jira.jboss.org/browse/ISPN-579] for more details.";
    }

    @Override
    public final void sqlFailureReadingKey(Object key, Object lockingKey, SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureReadingKey$str(), key, lockingKey);
    }

    protected String sqlFailureReadingKey$str() {
        return "ISPN008027: SQL error while fetching stored entry with key: %s, lockingKey: %s";
    }

    protected String tableManipulationAttributeNotSet$str() {
        return "ISPN008028: Attribute '%2$s' has not been set on '%1$s'";
    }

    @Override
    public final CacheConfigurationException tableManipulationAttributeNotSet(String groupName, String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.tableManipulationAttributeNotSet$str(), groupName, name));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingConnectionFactory$str() {
        return "ISPN008029: A ConnectionFactory has not been specified for this store";
    }

    @Override
    public final CacheConfigurationException missingConnectionFactory() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingConnectionFactory$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void sqlFailureTxCommit(SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureTxCommit$str(), new Object[0]);
    }

    protected String sqlFailureTxCommit$str() {
        return "ISPN008031: Error committing JDBC transaction";
    }

    @Override
    public final void sqlFailureTxRollback(SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureTxRollback$str(), new Object[0]);
    }

    protected String sqlFailureTxRollback$str() {
        return "ISPN008032: Error during rollback of JDBC transaction";
    }

    protected String prepareTxFailure$str() {
        return "ISPN008033: Exception encountered when preparing JDBC store Tx";
    }

    @Override
    public final PersistenceException prepareTxFailure(Throwable e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.prepareTxFailure$str(), new Object[0]), e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void twoWayKey2StringMapperIsMissing(String className) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.twoWayKey2StringMapperIsMissing$str(), (Object)className);
    }

    protected String twoWayKey2StringMapperIsMissing$str() {
        return "ISPN008036: Unable to notify the PurgeListener of expired cache entries as the configured key2StringMapper does not implement %s";
    }

    protected String sqlFailureWritingBatch$str() {
        return "ISPN008037: Error while writing entries in batch to the database:";
    }

    @Override
    public final PersistenceException sqlFailureWritingBatch(Throwable e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.sqlFailureWritingBatch$str(), new Object[0]), e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String existingStoreNoSegmentation$str() {
        return "ISPN008039: The existing store was created without segmentation enabled";
    }

    @Override
    public final CacheConfigurationException existingStoreNoSegmentation() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.existingStoreNoSegmentation$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String existingStoreSegmentMismatch$str() {
        return "ISPN008040: The existing store was created with %d segments configured, but the cache is configured with %d";
    }

    @Override
    public final CacheConfigurationException existingStoreSegmentMismatch(int existing, int cache) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.existingStoreSegmentMismatch$str(), existing, cache));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void sqlFailureMetaRetrieval(SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureMetaRetrieval$str(), new Object[0]);
    }

    protected String sqlFailureMetaRetrieval$str() {
        return "ISPN008041: Error retrieving JDBC metadata";
    }

    @Override
    public final void sqlFailureSize(SQLException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.sqlFailureSize$str(), new Object[0]);
    }

    protected String sqlFailureSize$str() {
        return "ISPN008042: SQL failure while retrieving size";
    }

    protected String primaryKeyMultipleColumnWithoutSchema$str() {
        return "ISPN008043: Primary key has multiple columns but no key message schema defined, which is required when there is more than one key column";
    }

    @Override
    public final CacheConfigurationException primaryKeyMultipleColumnWithoutSchema() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.primaryKeyMultipleColumnWithoutSchema$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String valueMultipleColumnWithoutSchema$str() {
        return "ISPN008044: Multiple non key columns but no value message schema defined, which is required when there is more than one value column";
    }

    @Override
    public final CacheConfigurationException valueMultipleColumnWithoutSchema() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.valueMultipleColumnWithoutSchema$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String keyNotInSchema$str() {
        return "ISPN008045: Primary key %s was not found in the key schema %s";
    }

    @Override
    public final CacheConfigurationException keyNotInSchema(String primaryKeyName, String schemaName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.keyNotInSchema$str(), primaryKeyName, schemaName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String valueNotInSchema$str() {
        return "ISPN008046: Additional value columns %s found that were not part of the schema, make sure the columns returned match the value schema %s";
    }

    @Override
    public final CacheConfigurationException valueNotInSchema(List<String> columnNames, String schemaName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.valueNotInSchema$str(), columnNames, schemaName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String schemaNotFound$str() {
        return "ISPN008047: Schema not found for : %s";
    }

    @Override
    public final CacheConfigurationException schemaNotFound(String schemaName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.schemaNotFound$str(), schemaName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String keyCannotEmbedWithEnum$str() {
        return "ISPN008048: Key cannot be embedded when the value schema %s is an enum";
    }

    @Override
    public final CacheConfigurationException keyCannotEmbedWithEnum(String schemaName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.keyCannotEmbedWithEnum$str(), schemaName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String repeatedFieldsNotSupported$str() {
        return "ISPN008049: Repeated fields are not supported, found %s in schema %s";
    }

    @Override
    public final CacheConfigurationException repeatedFieldsNotSupported(String fieldName, String schemaName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.repeatedFieldsNotSupported$str(), fieldName, schemaName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String duplicateFieldInSchema$str() {
        return "ISPN008050: Duplicate name %s found for nested schema: %s";
    }

    @Override
    public final CacheConfigurationException duplicateFieldInSchema(String fieldName, String schemaName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.duplicateFieldInSchema$str(), fieldName, schemaName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String requiredSchemaFieldNotPresent$str() {
        return "ISPN008051: Schema contained a field %s that is required but wasn't found in the query for schema %s";
    }

    @Override
    public final CacheConfigurationException requiredSchemaFieldNotPresent(String fieldName, String schemaName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.requiredSchemaFieldNotPresent$str(), fieldName, schemaName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String primaryKeyPresentButNotEmbedded$str() {
        return "ISPN008052: Primary key %s was found in the value schema %s but embedded key was not true";
    }

    @Override
    public final CacheConfigurationException primaryKeyPresentButNotEmbedded(String fieldName, String schemaName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.primaryKeyPresentButNotEmbedded$str(), fieldName, schemaName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String deleteAndSelectQueryMismatchArguments2$str() {
        return "ISPN008053: Delete and select queries do not have matching arguments. Delete was %s and select was %s";
    }

    @Override
    public final CacheConfigurationException deleteAndSelectQueryMismatchArguments(List<String> deleteParams, List<String> selectParams) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.deleteAndSelectQueryMismatchArguments2$str(), deleteParams, selectParams));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String deleteAndSelectQueryMismatchArguments3$str() {
        return "ISPN008054: Named parameter %s in upsert statement [%s] is not available in columns from selectAll statement [%s]";
    }

    @Override
    public final CacheConfigurationException deleteAndSelectQueryMismatchArguments(String paramName, String upsertStatement, String selectStatement) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.deleteAndSelectQueryMismatchArguments3$str(), paramName, upsertStatement, selectStatement));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String selectAllCannotHaveParameters$str() {
        return "ISPN008055: No parameters are allowed for select all statement %s";
    }

    @Override
    public final CacheConfigurationException selectAllCannotHaveParameters(String selectAllStatement) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.selectAllCannotHaveParameters$str(), selectAllStatement));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String deleteAllCannotHaveParameters$str() {
        return "ISPN008056: No parameters are allowed for delete all statement %s";
    }

    @Override
    public final CacheConfigurationException deleteAllCannotHaveParameters(String selectAllStatement) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.deleteAllCannotHaveParameters$str(), selectAllStatement));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String sizeCannotHaveParameters$str() {
        return "ISPN008057: No parameters are allowed for sizer statement %s";
    }

    @Override
    public final CacheConfigurationException sizeCannotHaveParameters(String selectAllStatement) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.sizeCannotHaveParameters$str(), selectAllStatement));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String keyColumnsNotReturnedFromSelectAll$str() {
        return "ISPN008058: Not all key columns %s were returned from select all statement %s";
    }

    @Override
    public final CacheConfigurationException keyColumnsNotReturnedFromSelectAll(String keyColumns, String selectAllStatement) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.keyColumnsNotReturnedFromSelectAll$str(), keyColumns, selectAllStatement));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String namedParamNotReturnedFromSelect$str() {
        return "ISPN008059: Select parameter %s is not returned from select all statement %s, select statement is %s";
    }

    @Override
    public final CacheConfigurationException namedParamNotReturnedFromSelect(String paramName, String selectAllStatement, String selectStatement) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.namedParamNotReturnedFromSelect$str(), paramName, selectAllStatement, selectStatement));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nonTerminatedNamedParamInSql$str() {
        return "ISPN008060: Non-terminated named parameter declaration at position %d in statement: %s";
    }

    @Override
    public final CacheConfigurationException nonTerminatedNamedParamInSql(int position, String sqlStatement) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.nonTerminatedNamedParamInSql$str(), position, sqlStatement));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidCharacterInSql$str() {
        return "ISPN008061: Invalid character %s at position %d in statement: %s";
    }

    @Override
    public final CacheConfigurationException invalidCharacterInSql(char character, int position, String sqlStatement) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidCharacterInSql$str(), Character.valueOf(character), position, sqlStatement));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unnamedParametersNotAllowed$str() {
        return "ISPN008062: Unnamed parameters are not allowed, found one at %d in statement %s";
    }

    @Override
    public final CacheConfigurationException unnamedParametersNotAllowed(int position, String sqlStatement) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unnamedParametersNotAllowed$str(), position, sqlStatement));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String tableNotInCorrectFormat$str() {
        return "ISPN008063: Provided table name %s is not in form of (<SCHEMA>.)<TABLE-NAME> where SCHEMA is optional";
    }

    @Override
    public final CacheConfigurationException tableNotInCorrectFormat(String tableName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.tableNotInCorrectFormat$str(), tableName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noPrimaryKeysFoundForTable$str() {
        return "ISPN008064: No primary keys found for table %s, check case sensitivity";
    }

    @Override
    public final CacheConfigurationException noPrimaryKeysFoundForTable(String tableName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.noPrimaryKeysFoundForTable$str(), tableName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noValueColumnForTable$str() {
        return "ISPN008065: No column found that wasn't a primary key for table: %s";
    }

    @Override
    public final CacheConfigurationException noValueColumnForTable(String tableName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.noValueColumnForTable$str(), tableName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToDetectDialect$str() {
        return "ISPN008066: Unable to detect database dialect from JDBC driver name or connection metadata.  Please provide this manually using the 'dialect' property in your configuration.  Supported database dialect strings are %s";
    }

    @Override
    public final CacheConfigurationException unableToDetectDialect(String supportedDialects) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unableToDetectDialect$str(), supportedDialects));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String requiredStatementsForQueryStoreLoader$str() {
        return "ISPN008067: The size, select and select all attributes must be set for a query store";
    }

    @Override
    public final CacheConfigurationException requiredStatementsForQueryStoreLoader() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.requiredStatementsForQueryStoreLoader$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String requiredStatementsForQueryStoreWriter$str() {
        return "ISPN008068: The delete, delete all and upsert attributes must be set for a query store that allows writes";
    }

    @Override
    public final CacheConfigurationException requiredStatementsForQueryStoreWriter() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.requiredStatementsForQueryStoreWriter$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String keyColumnsRequired$str() {
        return "ISPN008069: Key columns are required for QueryStore";
    }

    @Override
    public final CacheConfigurationException keyColumnsRequired() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.keyColumnsRequired$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String messageNameRequiredIfEmbeddedKey$str() {
        return "ISPN008070: Message name must not be null if embedded key is true";
    }

    @Override
    public final CacheConfigurationException messageNameRequiredIfEmbeddedKey() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.messageNameRequiredIfEmbeddedKey$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String tableNameMissing$str() {
        return "ISPN008071: Table name must be non null";
    }

    @Override
    public final CacheConfigurationException tableNameMissing() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.tableNameMissing$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void sqlMetadataNotPresent(String tableName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.sqlMetadataNotPresent$str(), (Object)tableName);
    }

    protected String sqlMetadataNotPresent$str() {
        return "ISPN008072: There was no JDBC metadata present in table %s, unable to confirm if segments are properly configured! Segments are assumed to be properly configured.";
    }
}

