/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import org.immutables.value.internal.$generator$.$AnnotationMirrors;
import org.immutables.value.internal.$generator$.$SourceExtraction;
import org.immutables.value.internal.$generator$.$SourceTypes;
import org.immutables.value.internal.$guava$.base.$Ascii;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$guava$.collect.$Lists;
import org.immutables.value.internal.$guava$.collect.$Maps;
import org.immutables.value.internal.$processor$.encode.$SourceStructureGet;
import org.immutables.value.internal.$processor$.meta.$Annotations;
import org.immutables.value.internal.$processor$.meta.$CachingElements;
import org.immutables.value.internal.$processor$.meta.$ImportsTypeStringResolver;
import org.immutables.value.internal.$processor$.meta.$Reporter;
import org.immutables.value.internal.$processor$.meta.$ValueAttribute;

class $TypeStringProvider {
    private final TypeMirror startType;
    private final Element element;
    private final List<String> typeParameterStrings = $Lists.newArrayListWithCapacity(2);
    private StringBuilder buffer;
    boolean unresolvedTypeHasOccured;
    boolean hasMaybeUnresolvedYetAfter;
    boolean hasTypeVariables;
    private String rawTypeName;
    private String returnTypeName;
    private boolean ended;
    private boolean lookedIntoReturnTypeString;
    @Nullable
    private List<String> workaroundTypeParameters;
    @Nullable
    private String workaroundTypeString;
    private final $Reporter reporter;
    private final String[] allowedTypevars;
    @Nullable
    private final String[] typevarArguments;
    private final $ImportsTypeStringResolver importsResolver;
    private final String nullableAnnotationName;
    boolean processNestedTypeUseAnnotations;
    boolean forAttribute = false;
    $ValueAttribute.NullElements nullElements = $ValueAttribute.NullElements.BAN;
    boolean nullableTypeAnnotation;
    @Nullable
    SourceExtractionCache sourceExtractionCache;
    private Set<String> unresolvedYetArguments;
    static final String EPHEMERAL_ANNOTATION_ALLOW_NULLS = "AllowNulls";
    static final String EPHEMERAL_ANNOTATION_SKIP_NULLS = "SkipNulls";

    $TypeStringProvider($Reporter reporter, Element element, TypeMirror startType, $ImportsTypeStringResolver importsResolver, String[] allowedTypevars, @Nullable String[] typevarArguments, String nullableAnnotationName) {
        this.reporter = reporter;
        this.startType = startType;
        this.element = element;
        this.allowedTypevars = allowedTypevars;
        this.typevarArguments = typevarArguments;
        this.importsResolver = importsResolver;
        this.nullableAnnotationName = nullableAnnotationName;
        $Preconditions.checkArgument(typevarArguments == null || allowedTypevars.length == typevarArguments.length, "Element %s, mismatching type variables, allowed: %s, given: %s", (Object)element.getSimpleName(), Arrays.asList(allowedTypevars), typevarArguments == null ? null : Arrays.asList(typevarArguments));
    }

    String rawTypeName() {
        return this.rawTypeName;
    }

    String returnTypeName() {
        return this.returnTypeName;
    }

    boolean hasSomeUnresovedTypes() {
        return this.hasMaybeUnresolvedYetAfter;
    }

    $ImmutableList<String> typeParameters() {
        return $ImmutableList.copyOf(this.workaroundTypeParameters != null ? this.workaroundTypeParameters : this.typeParameterStrings);
    }

    void process() {
        if (this.startType.getKind().isPrimitive()) {
            String typeName;
            this.rawTypeName = typeName = $Ascii.toLowerCase(this.startType.getKind().name());
            this.returnTypeName = typeName;
            List<? extends AnnotationMirror> annotations = this.startType.getAnnotationMirrors();
            if (!annotations.isEmpty()) {
                this.returnTypeName = this.typeAnnotationsToBuffer(annotations, false).append(typeName).toString();
            }
        } else {
            this.buffer = new StringBuilder(100);
            this.caseType(this.startType);
            if (this.workaroundTypeString != null) {
                this.buffer = new StringBuilder(this.workaroundTypeString);
            }
            TypeKind k = this.startType.getKind();
            switch (k) {
                case DECLARED: 
                case ERROR: {
                    assert (this.rawTypeName != null);
                    this.insertTypeAnnotationsIfPresent(this.startType, 0, this.rawTypeName.length());
                    break;
                }
                case ARRAY: 
                case TYPEVAR: {
                    String fqn;
                    boolean someNullabilityIsSet;
                    boolean inserted = this.rawTypeName != null && this.insertTypeAnnotationsIfPresent(this.startType, 0, this.rawTypeName.length());
                    boolean bl = someNullabilityIsSet = this.nullableTypeAnnotation || this.nullElements != $ValueAttribute.NullElements.BAN;
                    if (inserted || someNullabilityIsSet || this.lookedIntoReturnTypeString) break;
                    this.extractReturnTypeString(k);
                    if (!this.nullableTypeAnnotation || k != TypeKind.ARRAY || (fqn = this.importsResolver.apply(this.nullableAnnotationName)).equals(this.nullableAnnotationName)) break;
                    this.buffer.setLength(this.buffer.length() - 2);
                    this.buffer.append(" @").append(fqn).append(" []");
                }
            }
            if (this.buffer.length() > 0 && this.buffer.charAt(0) == '.') {
                this.buffer.deleteCharAt(0);
            }
            this.returnTypeName = this.buffer.toString();
        }
    }

    private void appendResolved(DeclaredType type) {
        TypeElement typeElement = (TypeElement)type.asElement();
        String typeName = typeElement.getQualifiedName().toString();
        if (this.unresolvedTypeHasOccured) {
            typeName = type == this.startType && this.forAttribute ? this.importsResolver.resolveTopForAttribute(typeName) : this.importsResolver.apply(typeName);
            if (type != this.startType && this.importsResolver.unresolved && this.unresolvedYetArguments != null) {
                this.unresolvedYetArguments.add(typeName);
            }
            this.hasMaybeUnresolvedYetAfter |= this.importsResolver.unresolved;
        } else if (typeName.startsWith("java.lang.")) {
            String simpleName = typeElement.getSimpleName().toString();
            if (typeName.equals("java.lang." + simpleName)) {
                String guessedName = this.importsResolver.apply(simpleName);
                if (!this.importsResolver.unresolved) {
                    typeName = guessedName;
                }
            }
        }
        if (typeName.startsWith(".")) {
            typeName = typeName.substring(1);
        }
        this.buffer.append(typeName);
        if (this.startType == type) {
            this.rawTypeName = typeName;
        }
    }

    private boolean insertTypeAnnotationsIfPresent(TypeMirror type, int typeStart, int typeEnd) {
        List<? extends AnnotationMirror> annotations = type.getAnnotationMirrors();
        if (!annotations.isEmpty()) {
            StringBuilder annotationBuffer = this.typeAnnotationsToBuffer(annotations, false);
            int insertionIndex = typeStart + this.buffer.substring(typeStart, typeEnd).lastIndexOf(46) + 1;
            this.buffer.insert(insertionIndex, annotationBuffer);
            return true;
        }
        return false;
    }

    private StringBuilder typeAnnotationsToBuffer(List<? extends AnnotationMirror> annotations, boolean nestedTypeUse) {
        StringBuilder annotationBuffer = new StringBuilder(100);
        for (AnnotationMirror annotationMirror : annotations) {
            boolean canBeAppliedToMethodAsWell;
            block5: {
                if (!nestedTypeUse) {
                    try {
                        if (!annotationMirror.getAnnotationType().asElement().getSimpleName().contentEquals(EPHEMERAL_ANNOTATION_ALLOW_NULLS)) break block5;
                        this.nullElements = $ValueAttribute.NullElements.ALLOW;
                    }
                    catch (Throwable justInCaseAnyCompilerBug) {
                        continue;
                    }
                }
            }
            boolean bl = canBeAppliedToMethodAsWell = !nestedTypeUse && $Annotations.annotationMatchesTarget(annotationMirror.getAnnotationType().asElement(), ElementType.METHOD);
            if (canBeAppliedToMethodAsWell) continue;
            CharSequence sequence = $AnnotationMirrors.toCharSequence(annotationMirror, this.importsResolver);
            if (!this.nullableTypeAnnotation && sequence.toString().endsWith(this.nullableAnnotationName)) {
                this.nullableTypeAnnotation = true;
            }
            annotationBuffer.append(sequence).append(' ');
        }
        return annotationBuffer;
    }

    private boolean tryToUseSourceAsAWorkaround(TypeKind typeKind) {
        if (this.element.getKind() != ElementKind.METHOD) {
            return false;
        }
        CharSequence returnTypeString = this.extractReturnTypeString(typeKind);
        if (returnTypeString == null || returnTypeString.length() == 0) {
            return false;
        }
        Map.Entry<String, List<String>> extractedTypes = $SourceTypes.extract(returnTypeString);
        Map.Entry<String, List<String>> resolvedTypes = this.resolveTypes(extractedTypes);
        this.rawTypeName = resolvedTypes.getKey();
        this.workaroundTypeParameters = resolvedTypes.getValue();
        this.workaroundTypeString = $SourceTypes.stringify(resolvedTypes);
        return true;
    }

    @Nullable
    private CharSequence extractReturnTypeString(TypeKind typeKind) {
        try {
            boolean wasLooked = this.lookedIntoReturnTypeString;
            this.lookedIntoReturnTypeString = true;
            if (!(this.element instanceof ExecutableElement)) {
                return null;
            }
            CharSequence returnTypeString = $SourceExtraction.getReturnTypeString($CachingElements.getDelegate((ExecutableElement)this.element));
            if (returnTypeString.length() == 0 && this.sourceExtractionCache != null) {
                $SourceStructureGet sourceStructure = this.sourceExtractionCache.readCachedSourceGet();
                if (sourceStructure != null) {
                    String accessorPath = this.computePath((ExecutableElement)this.element);
                    String returnType = sourceStructure.getReturnType(accessorPath);
                    if (!wasLooked && !this.nullableTypeAnnotation && this.nullElements == $ValueAttribute.NullElements.BAN) {
                        String annotations = sourceStructure.getAnnotations(accessorPath);
                        if (typeKind == TypeKind.ARRAY) {
                            String signature = sourceStructure.getSignature(accessorPath);
                            if (signature.contains("@" + this.nullableAnnotationName + "[]")) {
                                this.nullableTypeAnnotation = true;
                            }
                        } else if (typeKind == TypeKind.TYPEVAR && annotations.contains(this.nullableAnnotationName)) {
                            this.nullableTypeAnnotation = true;
                        }
                    }
                    return returnType;
                }
                return null;
            }
            if (!wasLooked && !this.nullableTypeAnnotation && this.nullElements == $ValueAttribute.NullElements.BAN && returnTypeString.toString().indexOf(this.nullableAnnotationName) > 0) {
                this.nullableTypeAnnotation = true;
            }
            return returnTypeString;
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Error | RuntimeException bestEffortsMiserablyFailed) {
            return null;
        }
    }

    private String computePath(ExecutableElement element) {
        String path = element.getSimpleName().toString();
        Element e = element.getEnclosingElement();
        while (e.getKind().isClass() || e.getKind().isInterface()) {
            path = e.getSimpleName() + "." + path;
            e = e.getEnclosingElement();
        }
        if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return path;
        }
        return path + "()";
    }

    private Map.Entry<String, List<String>> resolveTypes(Map.Entry<String, List<String>> sourceTypes) {
        String typeName = sourceTypes.getKey();
        typeName = this.importsResolver.apply(typeName);
        this.hasMaybeUnresolvedYetAfter |= this.importsResolver.unresolved;
        ArrayList<String> typeArguments = $Lists.newArrayListWithCapacity(sourceTypes.getValue().size());
        for (String typeArgument : sourceTypes.getValue()) {
            String resolvedTypeArgument = $SourceTypes.stringify(this.resolveTypes($SourceTypes.extract(typeArgument)));
            typeArguments.add(resolvedTypeArgument);
        }
        return $Maps.immutableEntry(typeName, typeArguments);
    }

    void caseType(TypeMirror type) {
        if (this.ended) {
            return;
        }
        TypeKind typeKind = type.getKind();
        switch (typeKind) {
            case ERROR: {
                this.unresolvedTypeHasOccured = true;
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)type;
                this.appendResolved(declaredType);
                this.appendTypeArguments(type, declaredType);
                break;
            }
            case ARRAY: {
                TypeMirror componentType = ((ArrayType)type).getComponentType();
                int mark = this.buffer.length();
                this.caseType(componentType);
                this.cutTypeArgument(type, mark);
                this.buffer.append('[').append(']');
                break;
            }
            case WILDCARD: {
                WildcardType wildcard = (WildcardType)type;
                TypeMirror extendsBound = wildcard.getExtendsBound();
                TypeMirror superBound = wildcard.getSuperBound();
                if (extendsBound != null) {
                    this.buffer.append("? extends ");
                    this.caseType(extendsBound);
                    break;
                }
                if (superBound != null) {
                    this.buffer.append("? super ");
                    this.caseType(superBound);
                    break;
                }
                this.buffer.append('?');
                break;
            }
            case TYPEVAR: {
                if (this.allowedTypevars.length != 0) {
                    TypeVariable typeVariable = (TypeVariable)type;
                    String var = typeVariable.asElement().getSimpleName().toString();
                    int indexOfVar = Arrays.asList(this.allowedTypevars).indexOf(var);
                    if (indexOfVar >= 0) {
                        if (this.typevarArguments != null) {
                            this.buffer.append(this.typevarArguments[indexOfVar]);
                            break;
                        }
                        this.hasTypeVariables = true;
                        this.buffer.append(var);
                        break;
                    }
                }
                if (this.tryToUseSourceAsAWorkaround(typeKind)) {
                    this.ended = true;
                    break;
                }
                this.reporter.withElement(this.element).error("It is a compiler/annotation processing bug to receive type variable '%s' here. To avoid it \u2014 do not use not yet generated types in %s attribute", type, this.element.getSimpleName());
                this.buffer.append(type);
                break;
            }
            case BOOLEAN: 
            case CHAR: 
            case INT: 
            case DOUBLE: 
            case FLOAT: 
            case SHORT: 
            case LONG: 
            case BYTE: {
                String typeName = $Ascii.toLowerCase(typeKind.name());
                this.buffer.append(typeName);
                break;
            }
            default: {
                this.buffer.append(type);
            }
        }
        if (this.unresolvedTypeHasOccured && this.buffer.toString().contains("<any>") && this.tryToUseSourceAsAWorkaround(typeKind)) {
            this.ended = true;
        }
    }

    private void appendTypeArguments(TypeMirror type, DeclaredType declaredType) {
        List<? extends TypeMirror> arguments = declaredType.getTypeArguments();
        if (!arguments.isEmpty()) {
            this.buffer.append('<');
            boolean notFirst = false;
            for (TypeMirror typeMirror : arguments) {
                this.typeAnnotationHandle(typeMirror);
                if (notFirst) {
                    this.buffer.append(',').append(' ');
                }
                notFirst = true;
                int mark = this.buffer.length();
                this.caseType(typeMirror);
                this.cutTypeArgument(type, mark);
            }
            this.buffer.append('>');
        }
    }

    private void typeAnnotationHandle(TypeMirror argument) {
        if (!this.processNestedTypeUseAnnotations) {
            return;
        }
        List<? extends AnnotationMirror> annotations = argument.getAnnotationMirrors();
        if (!annotations.isEmpty()) {
            String typeAnnotations = this.typeAnnotationsToBuffer(annotations, true).toString();
            this.assignElementNullness(typeAnnotations);
        }
    }

    private void assignElementNullness(String annotationString) {
        if (annotationString != null) {
            if (annotationString.contains(this.nullableAnnotationName) || annotationString.contains(EPHEMERAL_ANNOTATION_ALLOW_NULLS)) {
                this.nullElements = $ValueAttribute.NullElements.ALLOW;
            } else if (annotationString.contains(EPHEMERAL_ANNOTATION_SKIP_NULLS)) {
                this.nullElements = $ValueAttribute.NullElements.SKIP;
            }
        }
    }

    private void cutTypeArgument(TypeMirror type, int mark) {
        if (this.startType == type) {
            this.typeParameterStrings.add(this.buffer.substring(mark));
        }
    }

    void collectUnresolvedYetArgumentsTo(Set<String> unresolvedYetArguments) {
        this.unresolvedYetArguments = unresolvedYetArguments;
    }

    static interface SourceExtractionCache {
        @Nullable
        public $SourceStructureGet readCachedSourceGet();
    }
}

