/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.trees.ast;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import org.parboiled.Action;
import org.parboiled.Context;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.support.Position;

public final class Extractions {
    private Extractions() {
    }

    public static <T> Extractor<T> value(final T value) {
        return new Extractor<T>(){

            @Override
            public T get(Context<Object> context) {
                return value;
            }

            public String toString() {
                return Extractions.class.getSimpleName() + ".value(" + value + ")";
            }
        };
    }

    public static Extractor<String> matched() {
        return MatchExtractor.INSTANCE;
    }

    public static Extractor<Position> position() {
        return PositionExtractor.INSTANCE;
    }

    public static <T> Extractor<T> popped() {
        return PopExtractor.INSTANCE;
    }

    public static <F, T> Extractor<T> popped(final Function<F, T> transform) {
        return new Extractor<T>(){

            @Override
            public T get(Context<Object> context) {
                return transform.apply(Extractions.popped().get(context));
            }

            public String toString() {
                return Extractions.class.getSimpleName() + ".popped(" + transform + ")";
            }
        };
    }

    public static Applicator print() {
        return new Applicator(){

            public boolean run(Context<Object> context) {
                Extractions.printContext(this, (Context<Object>)context);
                return true;
            }

            public String toString() {
                return Extractions.class.getSimpleName() + ".print()";
            }
        };
    }

    private static void printContext(Object caller, Context<Object> context) {
        String message = ErrorUtils.printErrorMessage((String)"%s:%s:%s", (String)"", (int)context.getCurrentIndex(), (int)(context.getCurrentIndex() + 1), (InputBuffer)context.getInputBuffer());
        System.err.println("*** " + caller + message + "\n\t" + Joiner.on((String)"\n\t - ").join((Iterable)context.getValueStack()));
    }

    public static abstract class Builder<B>
    implements Applicator {
        public final boolean run(Context<Object> context) {
            B builder = this.builder();
            context.getValueStack().push(builder);
            return true;
        }

        public abstract B builder();
    }

    public static abstract class Build<B, T>
    extends ExtractorApplicator<T> {
        @Override
        public final T get(Context<Object> context) {
            Object builder = context.getValueStack().pop();
            return this.build(builder);
        }

        public abstract T build(B var1);
    }

    public static abstract class Specify<B, V>
    implements Applicator {
        private final Extractor<? extends V> extractor;

        protected Specify(Extractor<? extends V> extractor) {
            this.extractor = extractor;
        }

        public final boolean run(Context<Object> context) {
            V value = this.extractor.get(context);
            Object builder = context.getValueStack().peek();
            this.specify(builder, value);
            return true;
        }

        public abstract void specify(B var1, V var2);
    }

    public static abstract class Construct<T, V>
    extends ExtractorApplicator<T> {
        private final Extractor<? extends V> extractor;

        protected Construct(Extractor<? extends V> extractor) {
            this.extractor = extractor;
        }

        @Override
        public final T get(Context<Object> context) {
            V value = this.extractor.get(context);
            return this.get(value);
        }

        public abstract T get(V var1);
    }

    public static abstract class Instance<T>
    extends ExtractorApplicator<T> {
        @Override
        public T get(Context<Object> context) {
            return this.get();
        }

        public abstract T get();
    }

    static abstract class ExtractorApplicator<T>
    implements Extractor<T>,
    Applicator {
        ExtractorApplicator() {
        }

        public final boolean run(Context<Object> context) {
            Object value = this.get(context);
            context.getValueStack().push(value);
            return true;
        }
    }

    private static enum PopExtractor implements Extractor<Object>,
    Applicator
    {
        INSTANCE;


        @Override
        public Object get(Context<Object> context) {
            return context.getValueStack().pop();
        }

        public boolean run(Context<Object> context) {
            this.get(context);
            return true;
        }

        public String toString() {
            return Extractions.class.getSimpleName() + ".popped()";
        }
    }

    private static enum PositionExtractor implements Extractor<Position>
    {
        INSTANCE;


        @Override
        public Position get(Context<Object> context) {
            return context.getPosition();
        }

        public String toString() {
            return Extractions.class.getSimpleName() + ".position()";
        }
    }

    private static enum MatchExtractor implements Extractor<String>
    {
        INSTANCE;


        @Override
        public String get(Context<Object> context) {
            return context.getMatch();
        }

        public String toString() {
            return Extractions.class.getSimpleName() + ".matched()";
        }
    }

    public static interface Applicator
    extends Action<Object> {
    }

    public static interface Extractor<T> {
        public T get(Context<Object> var1);
    }
}

