/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.util.XMLParser;

public class TaxonomyPlugin
extends AbstractPlugin {
    public static final String INVALID_FORMAT = "INVALID_FORMAT";
    private static Logger logger = Logger.getLogger(TaxonomyPlugin.class.getName());

    public ItemCollection run(ItemCollection documentContext, ItemCollection event) throws PluginException {
        logger.finest("running TaxonomyPlugin");
        ItemCollection taxonomyConfig = this.getWorkflowService().evalWorkflowResult(event, "taxonomy", documentContext, true);
        if (taxonomyConfig == null || taxonomyConfig.getItemNames().size() == 0) {
            return documentContext;
        }
        for (String name : taxonomyConfig.getItemNames()) {
            logger.finest("found taxonomy name=" + name);
            String xmlDef = taxonomyConfig.getItemValueString(name);
            ItemCollection taxonomyData = XMLParser.parseItemStructure((String)xmlDef);
            if (taxonomyData == null) continue;
            String type = taxonomyData.getItemValueString("type");
            boolean anonymised = true;
            if (taxonomyData.hasItem("anonymised")) {
                anonymised = taxonomyData.getItemValueBoolean("anonymised");
            }
            logger.finest("... type=" + type + "  anonymised=" + anonymised);
            this.evalTaxonomyDefinition(documentContext, name, type, anonymised);
        }
        return documentContext;
    }

    void evalTaxonomyDefinition(ItemCollection documentContext, String name, String type, boolean anonymised) throws PluginException {
        if (!name.matches("^[\\w.-]+$")) {
            throw new PluginException(TaxonomyPlugin.class.getSimpleName(), INVALID_FORMAT, "Invalid taxonomy definition - the name cannot contain special characters: '" + name + "'");
        }
        documentContext.appendItemValueUnique("taxonomy", (Object)name);
        List valuesStart = documentContext.getItemValue("taxonomy." + name + ".start");
        List valuesStop = documentContext.getItemValue("taxonomy." + name + ".stop");
        if ("start".equals(type)) {
            if (valuesStart.size() != valuesStop.size()) {
                logger.warning("Invalid taxonomy definition '" + name + "' starttime without stoptime! - please check model event " + documentContext.getTaskID() + "." + documentContext.getEventID() + " taxonomy will be ignored!");
                return;
            }
            valuesStart.add(0, new Date());
            documentContext.replaceItemValue("taxonomy." + name + ".start", (Object)valuesStart);
            if (!anonymised) {
                List owners = documentContext.getItemValue("$owner");
                documentContext.replaceItemValue("taxonomy." + name + ".start.by", (Object)owners);
            }
        }
        if ("stop".equals(type)) {
            if (valuesStop.size() != valuesStart.size() - 1) {
                logger.warning("Invalid taxonomy definition '" + name + "' stoptime without starttime! - please check model entry " + documentContext.getTaskID() + "." + documentContext.getEventID() + " taxonomy will be ignored!");
                return;
            }
            valuesStop.add(0, new Date());
            documentContext.replaceItemValue("taxonomy." + name + ".stop", (Object)valuesStop);
            int numTotal = documentContext.getItemValueInteger("taxonomy." + name + ".duration");
            Date start = (Date)valuesStart.get(0);
            Date stop = (Date)valuesStop.get(0);
            long lStart = start.getTime() / 1000L;
            long lStop = stop.getTime() / 1000L;
            numTotal = (int)((long)numTotal + (lStop - lStart));
            documentContext.replaceItemValue("taxonomy." + name + ".duration", (Object)numTotal);
            if (!anonymised) {
                List owners = documentContext.getItemValue("$editor");
                documentContext.replaceItemValue("taxonomy." + name + ".stop.by", (Object)owners);
            }
        }
    }
}

