/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Liveness;
import org.imixs.workflow.engine.SetupService;

@Liveness
@ApplicationScoped
public class HealthCheckService
implements HealthCheck {
    private String workflowVersion = null;
    private static Logger logger = Logger.getLogger(HealthCheckService.class.getName());
    @Inject
    private SetupService setupService;

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = null;
        int modelCount = 0;
        int groupCount = 0;
        boolean failure = false;
        boolean databaseFailure = false;
        boolean indexFailure = false;
        try {
            modelCount = this.setupService.getModelVersionCount();
            groupCount = this.setupService.getModelGroupCount();
        }
        catch (Exception e) {
            modelCount = 0;
            failure = true;
        }
        databaseFailure = !this.setupService.checkDatabase();
        boolean bl = indexFailure = !this.setupService.checkIndex();
        if (databaseFailure || indexFailure) {
            failure = true;
        }
        if (!failure) {
            builder = HealthCheckResponse.named((String)"imixs-workflow").withData("engine.version", this.getWorkflowVersion()).withData("model.versions", (long)modelCount).withData("model.groups", (long)groupCount).withData("database.status", "ok").withData("index.status", "ok").up();
        } else {
            builder = HealthCheckResponse.named((String)"imixs-workflow");
            if (databaseFailure) {
                builder.withData("database.status", "failure");
            } else {
                builder.withData("database.status", "ok");
            }
            if (indexFailure) {
                builder.withData("index.status", "failure");
            } else {
                builder.withData("index.status", "ok");
            }
            builder.down();
        }
        return builder.build();
    }

    private String getWorkflowVersion() {
        if (this.workflowVersion == null) {
            try {
                InputStream resourceAsStream = this.getClass().getResourceAsStream("/META-INF/maven/org.imixs.workflow/imixs-workflow-engine/pom.properties");
                if (resourceAsStream != null) {
                    Properties prop = new Properties();
                    prop.load(resourceAsStream);
                    this.workflowVersion = prop.getProperty("version");
                }
            }
            catch (IOException e1) {
                logger.warning("failed to load pom.properties");
            }
        }
        if (this.workflowVersion == null || this.workflowVersion.isEmpty()) {
            this.workflowVersion = "unknown";
        }
        return this.workflowVersion;
    }
}

