/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.dns.minidns;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.initializer.SmackInitializer;
import org.jivesoftware.smack.util.DNSUtil;
import org.jivesoftware.smack.util.dns.DNSResolver;
import org.jivesoftware.smack.util.dns.minidns.MiniDnsDane;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpointLookupFailure;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsmessage.Question;
import org.minidns.dnsname.DnsName;
import org.minidns.dnssec.DnssecResultNotAuthenticException;
import org.minidns.hla.DnssecResolverApi;
import org.minidns.hla.ResolutionUnsuccessfulException;
import org.minidns.hla.ResolverApi;
import org.minidns.hla.ResolverResult;
import org.minidns.hla.SrvResolverResult;
import org.minidns.record.A;
import org.minidns.record.AAAA;
import org.minidns.record.SRV;

public class MiniDnsResolver
extends DNSResolver
implements SmackInitializer {
    private static final MiniDnsResolver INSTANCE = new MiniDnsResolver();
    private static final ResolverApi DNSSEC_RESOLVER = DnssecResolverApi.INSTANCE;
    private static final ResolverApi NON_DNSSEC_RESOLVER = ResolverApi.INSTANCE;

    public static DNSResolver getInstance() {
        return INSTANCE;
    }

    public MiniDnsResolver() {
        super(true);
    }

    protected Set<SRV> lookupSrvRecords0(DnsName name, List<RemoteConnectionEndpointLookupFailure> lookupFailures, ConnectionConfiguration.DnssecMode dnssecMode) {
        SrvResolverResult result;
        ResolverApi resolver = MiniDnsResolver.getResolver(dnssecMode);
        try {
            result = resolver.resolveSrv(name);
        }
        catch (IOException e) {
            RemoteConnectionEndpointLookupFailure.DnsLookupFailure failure = new RemoteConnectionEndpointLookupFailure.DnsLookupFailure(name, (Exception)e);
            lookupFailures.add((RemoteConnectionEndpointLookupFailure)failure);
            return null;
        }
        ResolutionUnsuccessfulException resolutionUnsuccessfulException = result.getResolutionUnsuccessfulException();
        if (resolutionUnsuccessfulException != null) {
            RemoteConnectionEndpointLookupFailure.DnsLookupFailure failure = new RemoteConnectionEndpointLookupFailure.DnsLookupFailure(name, (Exception)resolutionUnsuccessfulException);
            lookupFailures.add((RemoteConnectionEndpointLookupFailure)failure);
            return null;
        }
        if (MiniDnsResolver.shouldAbortIfNotAuthentic(name, dnssecMode, result, lookupFailures)) {
            return null;
        }
        return result.getAnswers();
    }

    protected List<InetAddress> lookupHostAddress0(DnsName name, List<RemoteConnectionEndpointLookupFailure> lookupFailures, ConnectionConfiguration.DnssecMode dnssecMode) {
        InetAddress inetAddress;
        ResolverResult aaaaResult;
        ResolverResult aResult;
        ResolverApi resolver = MiniDnsResolver.getResolver(dnssecMode);
        try {
            aResult = resolver.resolve(name, A.class);
            aaaaResult = resolver.resolve(name, AAAA.class);
        }
        catch (IOException e) {
            RemoteConnectionEndpointLookupFailure.DnsLookupFailure failure = new RemoteConnectionEndpointLookupFailure.DnsLookupFailure(name, (Exception)e);
            lookupFailures.add((RemoteConnectionEndpointLookupFailure)failure);
            return null;
        }
        if (!aResult.wasSuccessful() && !aaaaResult.wasSuccessful()) {
            RemoteConnectionEndpointLookupFailure.DnsLookupFailure failureA = new RemoteConnectionEndpointLookupFailure.DnsLookupFailure(name, (Exception)MiniDnsResolver.getExceptionFrom(aResult));
            lookupFailures.add((RemoteConnectionEndpointLookupFailure)failureA);
            RemoteConnectionEndpointLookupFailure.DnsLookupFailure failureAaaa = new RemoteConnectionEndpointLookupFailure.DnsLookupFailure(name, (Exception)MiniDnsResolver.getExceptionFrom(aaaaResult));
            lookupFailures.add((RemoteConnectionEndpointLookupFailure)failureAaaa);
            return null;
        }
        if (MiniDnsResolver.shouldAbortIfNotAuthentic(name, dnssecMode, aResult, lookupFailures) || MiniDnsResolver.shouldAbortIfNotAuthentic(name, dnssecMode, aaaaResult, lookupFailures)) {
            return null;
        }
        Set aResults = aResult.wasSuccessful() ? aResult.getAnswers() : Collections.emptySet();
        Set aaaaResults = aaaaResult.wasSuccessful() ? aaaaResult.getAnswers() : Collections.emptySet();
        ArrayList<InetAddress> inetAddresses = new ArrayList<InetAddress>(aResults.size() + aaaaResults.size());
        for (A a : aResults) {
            try {
                inetAddress = InetAddress.getByAddress(a.getIp());
            }
            catch (UnknownHostException e) {
                continue;
            }
            inetAddresses.add(inetAddress);
        }
        for (AAAA aaaa : aaaaResults) {
            try {
                inetAddress = InetAddress.getByAddress(name.ace, aaaa.getIp());
            }
            catch (UnknownHostException e) {
                continue;
            }
            inetAddresses.add(inetAddress);
        }
        return inetAddresses;
    }

    public static void setup() {
        DNSUtil.setDNSResolver((DNSResolver)MiniDnsResolver.getInstance());
    }

    public List<Exception> initialize() {
        MiniDnsResolver.setup();
        MiniDnsDane.setup();
        return null;
    }

    private static ResolverApi getResolver(ConnectionConfiguration.DnssecMode dnssecMode) {
        if (dnssecMode == ConnectionConfiguration.DnssecMode.disabled) {
            return NON_DNSSEC_RESOLVER;
        }
        return DNSSEC_RESOLVER;
    }

    private static boolean shouldAbortIfNotAuthentic(DnsName name, ConnectionConfiguration.DnssecMode dnssecMode, ResolverResult<?> result, List<RemoteConnectionEndpointLookupFailure> lookupFailures) {
        switch (dnssecMode) {
            case needsDnssec: 
            case needsDnssecAndDane: {
                DnssecResultNotAuthenticException exception = result.getDnssecResultNotAuthenticException();
                if (exception == null) break;
                RemoteConnectionEndpointLookupFailure.DnsLookupFailure failure = new RemoteConnectionEndpointLookupFailure.DnsLookupFailure(name, (Exception)exception);
                lookupFailures.add((RemoteConnectionEndpointLookupFailure)failure);
                return true;
            }
            case disabled: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown DnssecMode: " + dnssecMode);
            }
        }
        return false;
    }

    private static ResolutionUnsuccessfulException getExceptionFrom(ResolverResult<?> result) {
        Question question = result.getQuestion();
        DnsMessage.RESPONSE_CODE responseCode = result.getResponseCode();
        ResolutionUnsuccessfulException resolutionUnsuccessfulException = new ResolutionUnsuccessfulException(question, responseCode);
        return resolutionUnsuccessfulException;
    }
}

