/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox.element;

import java.util.Date;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.stringencoder.Base64;

public class PubkeyElement
implements ExtensionElement {
    public static final String NAMESPACE = "urn:xmpp:openpgp:0";
    public static final String ELEMENT = "pubkey";
    public static final String ATTR_DATE = "date";
    private final PubkeyDataElement dataElement;
    private final Date date;

    public PubkeyElement(PubkeyDataElement dataElement, Date date) {
        this.dataElement = (PubkeyDataElement)Objects.requireNonNull((Object)dataElement);
        this.date = date;
    }

    public PubkeyDataElement getDataElement() {
        return this.dataElement;
    }

    public Date getDate() {
        return this.date;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder((ExtensionElement)this).optAttribute(ATTR_DATE, this.date).rightAngleBracket().append((Element)this.getDataElement()).closeElement((NamedElement)this);
        return xml;
    }

    public static class PubkeyDataElement
    implements ExtensionElement {
        public static final String ELEMENT = "data";
        private final String b64Data;
        private transient byte[] pubKeyBytesCache;

        public PubkeyDataElement(String b64Data) {
            this.b64Data = (String)Objects.requireNonNull((Object)b64Data);
        }

        public String getB64Data() {
            return this.b64Data;
        }

        public byte[] getPubKeyBytes() {
            if (this.pubKeyBytesCache == null) {
                this.pubKeyBytesCache = Base64.decode((String)this.b64Data);
            }
            return (byte[])this.pubKeyBytesCache.clone();
        }

        public String getElementName() {
            return ELEMENT;
        }

        public String getNamespace() {
            return PubkeyElement.NAMESPACE;
        }

        public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder((FullyQualifiedElement)this, enclosingNamespace).rightAngleBracket().append((CharSequence)this.b64Data).closeElement((NamedElement)this);
            return xml;
        }
    }
}

