/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox;

import java.io.IOException;
import java.util.Collections;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.jivesoftware.smackx.ox.OpenPgpContact;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpStore;
import org.jxmpp.jid.BareJid;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.util.BCUtil;

public class OpenPgpSelf
extends OpenPgpContact {
    OpenPgpSelf(BareJid jid, OpenPgpStore store) {
        super(jid, store);
    }

    public boolean hasSecretKeyAvailable() throws IOException, PGPException {
        return this.getSecretKeys() != null;
    }

    public PGPSecretKeyRingCollection getSecretKeys() throws IOException, PGPException {
        return this.store.getSecretKeysOf(this.jid);
    }

    public PGPSecretKeyRing getSigningKeyRing() throws IOException, PGPException {
        PGPSecretKeyRingCollection secretKeyRings = this.getSecretKeys();
        if (secretKeyRings == null) {
            return null;
        }
        PGPSecretKeyRing signingKeyRing = null;
        for (PGPSecretKeyRing ring : secretKeyRings) {
            if (signingKeyRing == null) {
                signingKeyRing = ring;
                continue;
            }
            if (!ring.getPublicKey().getCreationTime().after(signingKeyRing.getPublicKey().getCreationTime())) continue;
            signingKeyRing = ring;
        }
        return signingKeyRing;
    }

    public OpenPgpV4Fingerprint getSigningKeyFingerprint() throws IOException, PGPException {
        PGPSecretKeyRing signingKeyRing = this.getSigningKeyRing();
        return signingKeyRing != null ? new OpenPgpV4Fingerprint(signingKeyRing.getPublicKey()) : null;
    }

    @Override
    public PGPPublicKeyRingCollection getAnnouncedPublicKeys() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = this.getSigningKeyRing();
        PGPPublicKeyRing publicKeys = this.getAnyPublicKeys().getPublicKeyRing(secretKeys.getPublicKey().getKeyID());
        publicKeys = BCUtil.removeUnassociatedKeysFromKeyRing((PGPPublicKeyRing)publicKeys, (PGPPublicKey)secretKeys.getPublicKey());
        return new PGPPublicKeyRingCollection(Collections.singleton(publicKeys));
    }
}

