/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iqregister;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaIdFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.iqregister.packet.Registration;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.parts.Localpart;

public final class AccountManager
extends Manager {
    private static final Map<XMPPConnection, AccountManager> INSTANCES = new WeakHashMap<XMPPConnection, AccountManager>();
    private static boolean allowSensitiveOperationOverInsecureConnectionDefault = false;
    private boolean allowSensitiveOperationOverInsecureConnection = allowSensitiveOperationOverInsecureConnectionDefault;
    private Registration info = null;
    private boolean accountCreationSupported = false;

    public static synchronized AccountManager getInstance(XMPPConnection connection) {
        AccountManager accountManager = INSTANCES.get(connection);
        if (accountManager == null) {
            accountManager = new AccountManager(connection);
            INSTANCES.put(connection, accountManager);
        }
        return accountManager;
    }

    public static void sensitiveOperationOverInsecureConnectionDefault(boolean allow) {
        allowSensitiveOperationOverInsecureConnectionDefault = allow;
    }

    public void sensitiveOperationOverInsecureConnection(boolean allow) {
        this.allowSensitiveOperationOverInsecureConnection = allow;
    }

    private AccountManager(XMPPConnection connection) {
        super(connection);
    }

    void setSupportsAccountCreation(boolean accountCreationSupported) {
        this.accountCreationSupported = accountCreationSupported;
    }

    public boolean supportsAccountCreation() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        if (this.accountCreationSupported) {
            return true;
        }
        if (this.info == null) {
            this.getRegistrationInfo();
            this.accountCreationSupported = this.info.getType() != IQ.Type.error;
        }
        return this.accountCreationSupported;
    }

    public Set<String> getAccountAttributes() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Map<String, String> attributes;
        if (this.info == null) {
            this.getRegistrationInfo();
        }
        if ((attributes = this.info.getAttributes()) != null) {
            return Collections.unmodifiableSet(attributes.keySet());
        }
        return Collections.emptySet();
    }

    public String getAccountAttribute(String name) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        if (this.info == null) {
            this.getRegistrationInfo();
        }
        return this.info.getAttributes().get(name);
    }

    public String getAccountInstructions() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        if (this.info == null) {
            this.getRegistrationInfo();
        }
        return this.info.getInstructions();
    }

    public void createAccount(Localpart username, String password) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (String attributeName : this.getAccountAttributes()) {
            attributes.put(attributeName, "");
        }
        this.createAccount(username, password, attributes);
    }

    public void createAccount(Localpart username, String password, Map<String, String> attributes) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        if (!this.connection().isSecureConnection() && !this.allowSensitiveOperationOverInsecureConnection) {
            throw new IllegalStateException("Creating account over insecure connection");
        }
        if (username == null) {
            throw new IllegalArgumentException("Username must not be null");
        }
        if (StringUtils.isNullOrEmpty((CharSequence)password)) {
            throw new IllegalArgumentException("Password must not be null");
        }
        attributes.put("username", username.toString());
        attributes.put("password", password);
        Registration reg = new Registration(attributes);
        reg.setType(IQ.Type.set);
        reg.setTo((Jid)this.connection().getXMPPServiceDomain());
        this.createStanzaCollectorAndSend(reg).nextResultOrThrow();
    }

    public void changePassword(String newPassword) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        if (!this.connection().isSecureConnection() && !this.allowSensitiveOperationOverInsecureConnection) {
            throw new IllegalStateException("Changing password over insecure connection.");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("username", this.connection().getUser().getLocalpart().toString());
        map.put("password", newPassword);
        Registration reg = new Registration(map);
        reg.setType(IQ.Type.set);
        reg.setTo((Jid)this.connection().getXMPPServiceDomain());
        this.createStanzaCollectorAndSend(reg).nextResultOrThrow();
    }

    public void deleteAccount() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("remove", "");
        Registration reg = new Registration(attributes);
        reg.setType(IQ.Type.set);
        reg.setTo((Jid)this.connection().getXMPPServiceDomain());
        this.createStanzaCollectorAndSend(reg).nextResultOrThrow();
    }

    public boolean isSupported() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        XMPPConnection connection = this.connection();
        ExtensionElement extensionElement = connection.getFeature("register", "http://jabber.org/features/iq-register");
        if (extensionElement != null) {
            return true;
        }
        if (connection.isAuthenticated()) {
            return ServiceDiscoveryManager.getInstanceFor(connection).serverSupportsFeature("jabber:iq:register");
        }
        return false;
    }

    private synchronized void getRegistrationInfo() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Registration reg = new Registration();
        reg.setTo((Jid)this.connection().getXMPPServiceDomain());
        this.info = (Registration)this.createStanzaCollectorAndSend(reg).nextResultOrThrow();
    }

    private StanzaCollector createStanzaCollectorAndSend(IQ req) throws SmackException.NotConnectedException, InterruptedException {
        StanzaCollector collector = this.connection().createStanzaCollectorAndSend((StanzaFilter)new StanzaIdFilter(req.getStanzaId()), (Stanza)req);
        return collector;
    }
}

