/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.admin;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.commands.AdHocCommandManager;
import org.jivesoftware.smackx.commands.RemoteCommand;
import org.jivesoftware.smackx.xdata.Form;
import org.jivesoftware.smackx.xdata.FormField;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.util.JidUtil;

public class ServiceAdministrationManager
extends Manager {
    public static final String COMMAND_NODE = "http://jabber.org/protocol/admin";
    private static final String COMMAND_NODE_HASHSIGN = "http://jabber.org/protocol/admin#";
    private static final Map<XMPPConnection, ServiceAdministrationManager> INSTANCES = new WeakHashMap<XMPPConnection, ServiceAdministrationManager>();
    private final AdHocCommandManager adHocCommandManager;

    public static synchronized ServiceAdministrationManager getInstanceFor(XMPPConnection connection) {
        ServiceAdministrationManager serviceAdministrationManager = INSTANCES.get(connection);
        if (serviceAdministrationManager == null) {
            serviceAdministrationManager = new ServiceAdministrationManager(connection);
            INSTANCES.put(connection, serviceAdministrationManager);
        }
        return serviceAdministrationManager;
    }

    public ServiceAdministrationManager(XMPPConnection connection) {
        super(connection);
        this.adHocCommandManager = AdHocCommandManager.getAddHocCommandsManager(connection);
    }

    public RemoteCommand addUser() {
        return this.addUser((Jid)this.connection().getServiceName());
    }

    public RemoteCommand addUser(Jid service) {
        return this.adHocCommandManager.getRemoteCommand(service, "http://jabber.org/protocol/admin#add-user");
    }

    public void addUser(EntityBareJid userJid, String password) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        RemoteCommand command = this.addUser();
        command.execute();
        Form answerForm = command.getForm().createAnswerForm();
        FormField accountJidField = answerForm.getField("accountjid");
        accountJidField.addValue(userJid.toString());
        FormField passwordField = answerForm.getField("password");
        passwordField.addValue(password);
        FormField passwordVerifyField = answerForm.getField("password-verify");
        passwordVerifyField.addValue(password);
        command.next(answerForm);
        assert (command.isCompleted());
    }

    public RemoteCommand deleteUser() {
        return this.deleteUser((Jid)this.connection().getServiceName());
    }

    public RemoteCommand deleteUser(Jid service) {
        return this.adHocCommandManager.getRemoteCommand(service, "http://jabber.org/protocol/admin#delete-user");
    }

    public void deleteUser(EntityBareJid userJidToDelete) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Set<EntityBareJid> userJidsToDelete = Collections.singleton(userJidToDelete);
        this.deleteUser(userJidsToDelete);
    }

    public void deleteUser(Set<EntityBareJid> jidsToDelete) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        RemoteCommand command = this.deleteUser();
        command.execute();
        Form answerForm = command.getForm().createAnswerForm();
        FormField accountJids = answerForm.getField("accountjids");
        accountJids.addValues(JidUtil.toStringList(jidsToDelete));
        command.next(answerForm);
        assert (command.isCompleted());
    }
}

