/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.filetransfer.FileTransfer;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jxmpp.jid.Jid;

public class OutgoingFileTransfer
extends FileTransfer {
    private static final Logger LOGGER = Logger.getLogger(OutgoingFileTransfer.class.getName());
    private static int RESPONSE_TIMEOUT = 60000;
    private NegotiationProgress callback;
    private OutputStream outputStream;
    private Jid initiator;
    private Thread transferThread;

    public static int getResponseTimeout() {
        return RESPONSE_TIMEOUT;
    }

    public static void setResponseTimeout(int responseTimeout) {
        RESPONSE_TIMEOUT = responseTimeout;
    }

    protected OutgoingFileTransfer(Jid initiator, Jid target, String streamID, FileTransferNegotiator transferNegotiator) {
        super(target, streamID, transferNegotiator);
        this.initiator = initiator;
    }

    protected void setOutputStream(OutputStream stream) {
        if (this.outputStream == null) {
            this.outputStream = stream;
        }
    }

    protected OutputStream getOutputStream() {
        if (this.getStatus().equals((Object)FileTransfer.Status.negotiated)) {
            return this.outputStream;
        }
        return null;
    }

    public synchronized OutputStream sendFile(String fileName, long fileSize, String description) throws XMPPException, SmackException, InterruptedException {
        if (this.isDone() || this.outputStream != null) {
            throw new IllegalStateException("The negotation process has already been attempted on this file transfer");
        }
        try {
            this.setFileInfo(fileName, fileSize);
            this.outputStream = this.negotiateStream(fileName, fileSize, description);
        }
        catch (XMPPException.XMPPErrorException e) {
            this.handleXMPPException(e);
            throw e;
        }
        return this.outputStream;
    }

    public synchronized void sendFile(final String fileName, final long fileSize, final String description, final NegotiationProgress progress) {
        if (progress == null) {
            throw new IllegalArgumentException("Callback progress cannot be null.");
        }
        this.checkTransferThread();
        if (this.isDone() || this.outputStream != null) {
            throw new IllegalStateException("The negotation process has already been attempted for this file transfer");
        }
        this.setFileInfo(fileName, fileSize);
        this.callback = progress;
        this.transferThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    OutgoingFileTransfer.this.outputStream = OutgoingFileTransfer.this.negotiateStream(fileName, fileSize, description);
                    progress.outputStreamEstablished(OutgoingFileTransfer.this.outputStream);
                }
                catch (XMPPException.XMPPErrorException e) {
                    OutgoingFileTransfer.this.handleXMPPException(e);
                }
                catch (Exception e) {
                    OutgoingFileTransfer.this.setException(e);
                }
            }
        }, "File Transfer Negotiation " + this.streamID);
        this.transferThread.start();
    }

    private void checkTransferThread() {
        if (this.transferThread != null && this.transferThread.isAlive() || this.isDone()) {
            throw new IllegalStateException("File transfer in progress or has already completed.");
        }
    }

    public synchronized void sendFile(final File file, final String description) throws SmackException {
        this.checkTransferThread();
        if (file == null || !file.exists() || !file.canRead()) {
            throw new IllegalArgumentException("Could not read file");
        }
        this.setFileInfo(file.getAbsolutePath(), file.getName(), file.length());
        this.transferThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    OutgoingFileTransfer.this.outputStream = OutgoingFileTransfer.this.negotiateStream(file.getName(), file.length(), description);
                }
                catch (XMPPException.XMPPErrorException e) {
                    OutgoingFileTransfer.this.handleXMPPException(e);
                    return;
                }
                catch (Exception e) {
                    OutgoingFileTransfer.this.setException(e);
                }
                if (OutgoingFileTransfer.this.outputStream == null) {
                    return;
                }
                if (!OutgoingFileTransfer.this.updateStatus(FileTransfer.Status.negotiated, FileTransfer.Status.in_progress)) {
                    return;
                }
                FileInputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(file);
                    OutgoingFileTransfer.this.writeToStream(inputStream, OutgoingFileTransfer.this.outputStream);
                }
                catch (FileNotFoundException e) {
                    OutgoingFileTransfer.this.setStatus(FileTransfer.Status.error);
                    OutgoingFileTransfer.this.setError(FileTransfer.Error.bad_file);
                    OutgoingFileTransfer.this.setException(e);
                }
                catch (IOException e) {
                    OutgoingFileTransfer.this.setStatus(FileTransfer.Status.error);
                    OutgoingFileTransfer.this.setException(e);
                }
                finally {
                    if (inputStream != null) {
                        try {
                            ((InputStream)inputStream).close();
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.WARNING, "Closing input stream", e);
                        }
                    }
                    try {
                        OutgoingFileTransfer.this.outputStream.close();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Closing output stream", e);
                    }
                }
                OutgoingFileTransfer.this.updateStatus(FileTransfer.Status.in_progress, FileTransfer.Status.complete);
            }
        }, "File Transfer " + this.streamID);
        this.transferThread.start();
    }

    public synchronized void sendStream(final InputStream in, final String fileName, final long fileSize, final String description) {
        this.checkTransferThread();
        this.setFileInfo(fileName, fileSize);
        this.transferThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    OutgoingFileTransfer.this.outputStream = OutgoingFileTransfer.this.negotiateStream(fileName, fileSize, description);
                }
                catch (XMPPException.XMPPErrorException e) {
                    OutgoingFileTransfer.this.handleXMPPException(e);
                    return;
                }
                catch (Exception e) {
                    OutgoingFileTransfer.this.setException(e);
                }
                if (OutgoingFileTransfer.this.outputStream == null) {
                    return;
                }
                if (!OutgoingFileTransfer.this.updateStatus(FileTransfer.Status.negotiated, FileTransfer.Status.in_progress)) {
                    return;
                }
                try {
                    OutgoingFileTransfer.this.writeToStream(in, OutgoingFileTransfer.this.outputStream);
                }
                catch (IOException e) {
                    OutgoingFileTransfer.this.setStatus(FileTransfer.Status.error);
                    OutgoingFileTransfer.this.setException(e);
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                        OutgoingFileTransfer.this.outputStream.flush();
                        OutgoingFileTransfer.this.outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                OutgoingFileTransfer.this.updateStatus(FileTransfer.Status.in_progress, FileTransfer.Status.complete);
            }
        }, "File Transfer " + this.streamID);
        this.transferThread.start();
    }

    private void handleXMPPException(XMPPException.XMPPErrorException e) {
        XMPPError error = e.getXMPPError();
        if (error != null) {
            switch (error.getCondition()) {
                case forbidden: {
                    this.setStatus(FileTransfer.Status.refused);
                    return;
                }
                case bad_request: {
                    this.setStatus(FileTransfer.Status.error);
                    this.setError(FileTransfer.Error.not_acceptable);
                    break;
                }
                default: {
                    this.setStatus(FileTransfer.Status.error);
                }
            }
        }
        this.setException((Exception)((Object)e));
    }

    public long getBytesSent() {
        return this.amountWritten;
    }

    private OutputStream negotiateStream(String fileName, long fileSize, String description) throws SmackException, XMPPException, InterruptedException {
        if (!this.updateStatus(FileTransfer.Status.initial, FileTransfer.Status.negotiating_transfer)) {
            throw new SmackException.IllegalStateChangeException();
        }
        StreamNegotiator streamNegotiator = this.negotiator.negotiateOutgoingTransfer(this.getPeer(), this.streamID, fileName, fileSize, description, RESPONSE_TIMEOUT);
        if (!this.updateStatus(FileTransfer.Status.negotiating_transfer, FileTransfer.Status.negotiating_stream)) {
            throw new SmackException.IllegalStateChangeException();
        }
        this.outputStream = streamNegotiator.createOutgoingStream(this.streamID, this.initiator, this.getPeer());
        if (!this.updateStatus(FileTransfer.Status.negotiating_stream, FileTransfer.Status.negotiated)) {
            throw new SmackException.IllegalStateChangeException();
        }
        return this.outputStream;
    }

    @Override
    public void cancel() {
        this.setStatus(FileTransfer.Status.cancelled);
    }

    @Override
    protected boolean updateStatus(FileTransfer.Status oldStatus, FileTransfer.Status newStatus) {
        boolean isUpdated = super.updateStatus(oldStatus, newStatus);
        if (this.callback != null && isUpdated) {
            this.callback.statusUpdated(oldStatus, newStatus);
        }
        return isUpdated;
    }

    @Override
    protected void setStatus(FileTransfer.Status status) {
        FileTransfer.Status oldStatus = this.getStatus();
        super.setStatus(status);
        if (this.callback != null) {
            this.callback.statusUpdated(oldStatus, status);
        }
    }

    @Override
    protected void setException(Exception exception) {
        super.setException(exception);
        if (this.callback != null) {
            this.callback.errorEstablishingStream(exception);
        }
    }

    public static interface NegotiationProgress {
        public void statusUpdated(FileTransfer.Status var1, FileTransfer.Status var2);

        public void outputStreamEstablished(OutputStream var1);

        public void errorEstablishingStream(Exception var1);
    }
}

