/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub.provider;

import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.PayloadItem;
import org.jivesoftware.smackx.pubsub.SimplePayload;
import org.xmlpull.v1.XmlPullParser;

public class ItemProvider
implements PacketExtensionProvider {
    public PacketExtension parseExtension(XmlPullParser parser) throws Exception {
        String payloadNS;
        String id = parser.getAttributeValue(null, "id");
        String node = parser.getAttributeValue(null, "node");
        String elem = parser.getName();
        int tag = parser.next();
        if (tag == 3) {
            return new Item(id, node);
        }
        String payloadElemName = parser.getName();
        if (ProviderManager.getExtensionProvider((String)payloadElemName, (String)(payloadNS = parser.getNamespace())) == null) {
            boolean done = false;
            boolean isEmptyElement = false;
            StringBuilder payloadText = new StringBuilder();
            while (!done) {
                if (tag == 3 && parser.getName().equals(elem)) {
                    done = true;
                    continue;
                }
                if (parser.getEventType() == 2) {
                    payloadText.append("<").append(parser.getName());
                    if (parser.getName().equals(payloadElemName) && payloadNS.length() > 0) {
                        payloadText.append(" xmlns=\"").append(payloadNS).append("\"");
                    }
                    int n = parser.getAttributeCount();
                    for (int i = 0; i < n; ++i) {
                        payloadText.append(" ").append(parser.getAttributeName(i)).append("=\"").append(parser.getAttributeValue(i)).append("\"");
                    }
                    if (parser.isEmptyElementTag()) {
                        payloadText.append("/>");
                        isEmptyElement = true;
                    } else {
                        payloadText.append(">");
                    }
                } else if (parser.getEventType() == 3) {
                    if (isEmptyElement) {
                        isEmptyElement = false;
                    } else {
                        payloadText.append("</").append(parser.getName()).append(">");
                    }
                } else if (parser.getEventType() == 4) {
                    payloadText.append(StringUtils.escapeForXML((String)parser.getText()));
                }
                tag = parser.next();
            }
            return new PayloadItem<SimplePayload>(id, node, new SimplePayload(payloadElemName, payloadNS, payloadText.toString()));
        }
        return new PayloadItem<PacketExtension>(id, node, PacketParserUtils.parsePacketExtension((String)payloadElemName, (String)payloadNS, (XmlPullParser)parser));
    }
}

