/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.privacy.packet;

public class PrivacyItem {
    public static final String SUBSCRIPTION_BOTH = "both";
    public static final String SUBSCRIPTION_TO = "to";
    public static final String SUBSCRIPTION_FROM = "from";
    public static final String SUBSCRIPTION_NONE = "none";
    private final boolean allow;
    private final int order;
    private final Type type;
    private final String value;
    private boolean filterIQ = false;
    private boolean filterMessage = false;
    private boolean filterPresenceIn = false;
    private boolean filterPresenceOut = false;

    public PrivacyItem(boolean allow, int order) {
        this(null, null, allow, order);
    }

    public PrivacyItem(Type type, String value, boolean allow, int order) {
        this.type = type;
        this.value = value;
        this.allow = allow;
        this.order = order;
    }

    public boolean isAllow() {
        return this.allow;
    }

    public boolean isFilterIQ() {
        return this.filterIQ;
    }

    public void setFilterIQ(boolean filterIQ) {
        this.filterIQ = filterIQ;
    }

    public boolean isFilterMessage() {
        return this.filterMessage;
    }

    public void setFilterMessage(boolean filterMessage) {
        this.filterMessage = filterMessage;
    }

    public boolean isFilterPresenceIn() {
        return this.filterPresenceIn;
    }

    public void setFilterPresenceIn(boolean filterPresenceIn) {
        this.filterPresenceIn = filterPresenceIn;
    }

    public boolean isFilterPresenceOut() {
        return this.filterPresenceOut;
    }

    public void setFilterPresenceOut(boolean filterPresenceOut) {
        this.filterPresenceOut = filterPresenceOut;
    }

    public int getOrder() {
        return this.order;
    }

    public Type getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isFilterEverything() {
        return !this.isFilterIQ() && !this.isFilterMessage() && !this.isFilterPresenceIn() && !this.isFilterPresenceOut();
    }

    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<item");
        if (this.isAllow()) {
            buf.append(" action=\"allow\"");
        } else {
            buf.append(" action=\"deny\"");
        }
        buf.append(" order=\"").append(this.getOrder()).append("\"");
        if (this.getType() != null) {
            buf.append(" type=\"").append((Object)this.getType()).append("\"");
        }
        if (this.getValue() != null) {
            buf.append(" value=\"").append(this.getValue()).append("\"");
        }
        if (this.isFilterEverything()) {
            buf.append("/>");
        } else {
            buf.append(">");
            if (this.isFilterIQ()) {
                buf.append("<iq/>");
            }
            if (this.isFilterMessage()) {
                buf.append("<message/>");
            }
            if (this.isFilterPresenceIn()) {
                buf.append("<presence-in/>");
            }
            if (this.isFilterPresenceOut()) {
                buf.append("<presence-out/>");
            }
            buf.append("</item>");
        }
        return buf.toString();
    }

    public static enum Type {
        group,
        jid,
        subscription;

    }
}

