/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.caps.cache;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.Base32Encoder;
import org.jivesoftware.smack.util.StringEncoder;
import org.jivesoftware.smackx.caps.EntityCapsManager;
import org.jivesoftware.smackx.caps.cache.EntityCapsPersistentCache;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.provider.DiscoverInfoProvider;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class SimpleDirectoryPersistentCache
implements EntityCapsPersistentCache {
    private static final Logger LOGGER = Logger.getLogger(SimpleDirectoryPersistentCache.class.getName());
    private File cacheDir;
    private StringEncoder filenameEncoder;

    public SimpleDirectoryPersistentCache(File cacheDir) {
        this(cacheDir, (StringEncoder)Base32Encoder.getInstance());
    }

    public SimpleDirectoryPersistentCache(File cacheDir, StringEncoder filenameEncoder) {
        if (!cacheDir.exists()) {
            throw new IllegalStateException("Cache directory \"" + cacheDir + "\" does not exist");
        }
        if (!cacheDir.isDirectory()) {
            throw new IllegalStateException("Cache directory \"" + cacheDir + "\" is not a directory");
        }
        this.cacheDir = cacheDir;
        this.filenameEncoder = filenameEncoder;
    }

    @Override
    public void addDiscoverInfoByNodePersistent(String node, DiscoverInfo info) {
        String filename = this.filenameEncoder.encode(node);
        File nodeFile = new File(this.cacheDir, filename);
        try {
            if (nodeFile.createNewFile()) {
                SimpleDirectoryPersistentCache.writeInfoToFile(nodeFile, info);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to write disco info to file", e);
        }
    }

    @Override
    public void replay() throws IOException {
        File[] files;
        for (File f : files = this.cacheDir.listFiles()) {
            String node = this.filenameEncoder.decode(f.getName());
            DiscoverInfo info = SimpleDirectoryPersistentCache.restoreInfoFromFile(f);
            if (info == null) continue;
            EntityCapsManager.addDiscoverInfoByNode(node, info);
        }
    }

    @Override
    public void emptyCache() {
        File[] files;
        for (File f : files = this.cacheDir.listFiles()) {
            f.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeInfoToFile(File file, DiscoverInfo info) throws IOException {
        try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(file));){
            dos.writeUTF(info.toXML().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DiscoverInfo restoreInfoFromFile(File file) throws IOException {
        DiscoverInfo iqPacket;
        String to;
        String from;
        String id;
        XmlPullParser parser;
        String fileContent = null;
        try (DataInputStream dis = new DataInputStream(new FileInputStream(file));){
            fileContent = dis.readUTF();
        }
        if (fileContent == null) {
            return null;
        }
        StringReader reader = new StringReader(fileContent);
        try {
            parser = XmlPullParserFactory.newInstance().newPullParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput((Reader)reader);
        }
        catch (XmlPullParserException xppe) {
            LOGGER.log(Level.SEVERE, "Exception initializing parser", xppe);
            return null;
        }
        DiscoverInfoProvider provider = new DiscoverInfoProvider();
        try {
            parser.next();
            id = parser.getAttributeValue("", "id");
            from = parser.getAttributeValue("", "from");
            to = parser.getAttributeValue("", "to");
            parser.next();
        }
        catch (XmlPullParserException e1) {
            return null;
        }
        try {
            iqPacket = (DiscoverInfo)provider.parseIQ(parser);
        }
        catch (Exception e) {
            return null;
        }
        iqPacket.setPacketID(id);
        iqPacket.setFrom(from);
        iqPacket.setTo(to);
        iqPacket.setType(IQ.Type.RESULT);
        return iqPacket;
    }
}

