/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bookmarks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smackx.bookmarks.BookmarkedConference;
import org.jivesoftware.smackx.bookmarks.BookmarkedURL;
import org.jivesoftware.smackx.iqprivate.packet.PrivateData;
import org.jivesoftware.smackx.iqprivate.provider.PrivateDataProvider;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class Bookmarks
implements PrivateData {
    private List<BookmarkedURL> bookmarkedURLS = new ArrayList<BookmarkedURL>();
    private List<BookmarkedConference> bookmarkedConferences = new ArrayList<BookmarkedConference>();

    public void addBookmarkedURL(BookmarkedURL bookmarkedURL) {
        this.bookmarkedURLS.add(bookmarkedURL);
    }

    public void removeBookmarkedURL(BookmarkedURL bookmarkedURL) {
        this.bookmarkedURLS.remove(bookmarkedURL);
    }

    public void clearBookmarkedURLS() {
        this.bookmarkedURLS.clear();
    }

    public void addBookmarkedConference(BookmarkedConference bookmarkedConference) {
        this.bookmarkedConferences.add(bookmarkedConference);
    }

    public void removeBookmarkedConference(BookmarkedConference bookmarkedConference) {
        this.bookmarkedConferences.remove(bookmarkedConference);
    }

    public void clearBookmarkedConferences() {
        this.bookmarkedConferences.clear();
    }

    public List<BookmarkedURL> getBookmarkedURLS() {
        return this.bookmarkedURLS;
    }

    public List<BookmarkedConference> getBookmarkedConferences() {
        return this.bookmarkedConferences;
    }

    @Override
    public String getElementName() {
        return "storage";
    }

    @Override
    public String getNamespace() {
        return "storage:bookmarks";
    }

    @Override
    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<storage xmlns=\"storage:bookmarks\">");
        for (BookmarkedURL urlStorage : this.getBookmarkedURLS()) {
            if (urlStorage.isShared()) continue;
            buf.append("<url name=\"").append(urlStorage.getName()).append("\" url=\"").append(urlStorage.getURL()).append("\"");
            if (urlStorage.isRss()) {
                buf.append(" rss=\"").append(true).append("\"");
            }
            buf.append(" />");
        }
        for (BookmarkedConference conference : this.getBookmarkedConferences()) {
            if (conference.isShared()) continue;
            buf.append("<conference ");
            buf.append("name=\"").append(conference.getName()).append("\" ");
            buf.append("autojoin=\"").append(conference.isAutoJoin()).append("\" ");
            buf.append("jid=\"").append(conference.getJid()).append("\" ");
            buf.append(">");
            if (conference.getNickname() != null) {
                buf.append("<nick>").append(conference.getNickname()).append("</nick>");
            }
            if (conference.getPassword() != null) {
                buf.append("<password>").append(conference.getPassword()).append("</password>");
            }
            buf.append("</conference>");
        }
        buf.append("</storage>");
        return buf.toString();
    }

    private static BookmarkedURL getURLStorage(XmlPullParser parser) throws IOException, XmlPullParserException {
        String name = parser.getAttributeValue("", "name");
        String url = parser.getAttributeValue("", "url");
        String rssString = parser.getAttributeValue("", "rss");
        boolean rss = rssString != null && "true".equals(rssString);
        BookmarkedURL urlStore = new BookmarkedURL(url, name, rss);
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2 && "shared_bookmark".equals(parser.getName())) {
                urlStore.setShared(true);
                continue;
            }
            if (eventType != 3 || !"url".equals(parser.getName())) continue;
            done = true;
        }
        return urlStore;
    }

    private static BookmarkedConference getConferenceStorage(XmlPullParser parser) throws Exception {
        String name = parser.getAttributeValue("", "name");
        String autojoin = parser.getAttributeValue("", "autojoin");
        String jid = parser.getAttributeValue("", "jid");
        BookmarkedConference conf = new BookmarkedConference(jid);
        conf.setName(name);
        conf.setAutoJoin(Boolean.valueOf(autojoin));
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2 && "nick".equals(parser.getName())) {
                conf.setNickname(parser.nextText());
                continue;
            }
            if (eventType == 2 && "password".equals(parser.getName())) {
                conf.setPassword(parser.nextText());
                continue;
            }
            if (eventType == 2 && "shared_bookmark".equals(parser.getName())) {
                conf.setShared(true);
                continue;
            }
            if (eventType != 3 || !"conference".equals(parser.getName())) continue;
            done = true;
        }
        return conf;
    }

    public static class Provider
    implements PrivateDataProvider {
        @Override
        public PrivateData parsePrivateData(XmlPullParser parser) throws Exception {
            Bookmarks storage = new Bookmarks();
            boolean done = false;
            while (!done) {
                int eventType = parser.next();
                if (eventType == 2 && "url".equals(parser.getName())) {
                    BookmarkedURL urlStorage = Bookmarks.getURLStorage(parser);
                    if (urlStorage == null) continue;
                    storage.addBookmarkedURL(urlStorage);
                    continue;
                }
                if (eventType == 2 && "conference".equals(parser.getName())) {
                    BookmarkedConference conference = Bookmarks.getConferenceStorage(parser);
                    storage.addBookmarkedConference(conference);
                    continue;
                }
                if (eventType != 3 || !"storage".equals(parser.getName())) continue;
                done = true;
            }
            return storage;
        }
    }
}

