/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.stanza_content_encryption.provider;

import java.io.IOException;
import java.util.Date;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.stanza_content_encryption.element.AffixElement;
import org.jivesoftware.smackx.stanza_content_encryption.element.ContentElement;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class ContentElementProvider
extends ExtensionElementProvider<ContentElement> {
    public ContentElement parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        ContentElement.Builder builder = ContentElement.builder();
        while (true) {
            XmlPullParser.Event tag;
            if ((tag = parser.next()) == XmlPullParser.Event.START_ELEMENT) {
                String name;
                switch (name = parser.getName()) {
                    case "to": {
                        ContentElementProvider.parseToAffix(parser, builder);
                        break;
                    }
                    case "from": {
                        ContentElementProvider.parseFromAffix(parser, builder);
                        break;
                    }
                    case "time": {
                        ContentElementProvider.parseTimestampAffix(parser, builder);
                        break;
                    }
                    case "rpad": {
                        ContentElementProvider.parseRPadAffix(parser, builder);
                        break;
                    }
                    case "payload": {
                        ContentElementProvider.parsePayload(parser, xmlEnvironment, builder);
                        break;
                    }
                    default: {
                        ContentElementProvider.parseCustomAffix(parser, xmlEnvironment, builder);
                        break;
                    }
                }
                continue;
            }
            if (tag == XmlPullParser.Event.END_ELEMENT && parser.getDepth() == initialDepth) break;
        }
        return builder.build();
    }

    private static void parseCustomAffix(XmlPullParser parser, XmlEnvironment outerXmlEnvironment, ContentElement.Builder builder) throws XmlPullParserException, IOException, SmackParsingException {
        String name = parser.getName();
        String namespace = parser.getNamespace();
        AffixElement element = (AffixElement)PacketParserUtils.parseExtensionElement((String)name, (String)namespace, (XmlPullParser)parser, (XmlEnvironment)outerXmlEnvironment);
        builder.addFurtherAffixElement(element);
    }

    private static void parsePayload(XmlPullParser parser, XmlEnvironment outerXmlEnvironment, ContentElement.Builder builder) throws IOException, XmlPullParserException, SmackParsingException {
        XmlPullParser.Event tag;
        int initialDepth = parser.getDepth();
        do {
            if ((tag = parser.next()) != XmlPullParser.Event.START_ELEMENT) continue;
            String name = parser.getName();
            String namespace = parser.getNamespace();
            ExtensionElement element = PacketParserUtils.parseExtensionElement((String)name, (String)namespace, (XmlPullParser)parser, (XmlEnvironment)outerXmlEnvironment);
            builder.addPayloadItem(element);
        } while (tag != XmlPullParser.Event.END_ELEMENT || parser.getDepth() != initialDepth);
    }

    private static void parseRPadAffix(XmlPullParser parser, ContentElement.Builder builder) throws IOException, XmlPullParserException {
        builder.setRandomPadding(parser.nextText());
    }

    private static void parseTimestampAffix(XmlPullParser parser, ContentElement.Builder builder) throws SmackParsingException.SmackTextParseException {
        Date timestamp = ParserUtils.getDateFromXep82String((String)parser.getAttributeValue("", "stamp"));
        builder.setTimestamp(timestamp);
    }

    private static void parseFromAffix(XmlPullParser parser, ContentElement.Builder builder) throws XmppStringprepException {
        String jidString = parser.getAttributeValue("", "jid");
        builder.setFrom(JidCreate.from((String)jidString));
    }

    private static void parseToAffix(XmlPullParser parser, ContentElement.Builder builder) throws XmppStringprepException {
        String jidString = parser.getAttributeValue("", "jid");
        builder.addTo(JidCreate.from((String)jidString));
    }
}

