/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.message_fastening.element;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.message_fastening.element.ExternalElement;
import org.jivesoftware.smackx.sid.element.OriginIdElement;

public final class FasteningElement
implements ExtensionElement {
    public static final String ELEMENT = "apply-to";
    public static final String NAMESPACE = "urn:xmpp:fasten:0";
    public static final String ATTR_ID = "id";
    public static final String ATTR_CLEAR = "clear";
    public static final String ATTR_SHELL = "shell";
    private final OriginIdElement referencedStanzasOriginId;
    private final List<ExternalElement> externalPayloads = new ArrayList<ExternalElement>();
    private final List<ExtensionElement> wrappedPayloads = new ArrayList<ExtensionElement>();
    private final boolean clear;
    private final boolean shell;

    private FasteningElement(OriginIdElement originId, List<ExtensionElement> wrappedPayloads, List<ExternalElement> externalPayloads, boolean clear, boolean shell) {
        this.referencedStanzasOriginId = (OriginIdElement)Objects.requireNonNull((Object)originId, (String)"Fastening element MUST contain an origin-id.");
        this.wrappedPayloads.addAll(wrappedPayloads);
        this.externalPayloads.addAll(externalPayloads);
        this.clear = clear;
        this.shell = shell;
    }

    public OriginIdElement getReferencedStanzasOriginId() {
        return this.referencedStanzasOriginId;
    }

    public List<ExtensionElement> getWrappedPayloads() {
        return Collections.unmodifiableList(this.wrappedPayloads);
    }

    public List<ExternalElement> getExternalPayloads() {
        return Collections.unmodifiableList(this.externalPayloads);
    }

    public boolean isRemovingElement() {
        return this.clear;
    }

    public boolean isShellElement() {
        return this.shell;
    }

    public static boolean hasFasteningElement(Message message) {
        return message.hasExtension(ELEMENT, NAMESPACE);
    }

    public static boolean hasFasteningElement(MessageBuilder builder) {
        return builder.hasExtension(FasteningElement.class);
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        XmlStringBuilder xml = new XmlStringBuilder((ExtensionElement)this).attribute(ATTR_ID, this.referencedStanzasOriginId.getId()).optBooleanAttribute(ATTR_CLEAR, this.isRemovingElement()).optBooleanAttribute(ATTR_SHELL, this.isShellElement()).rightAngleBracket();
        this.addPayloads(xml);
        return xml.closeElement((NamedElement)this);
    }

    private void addPayloads(XmlStringBuilder xml) {
        for (ExternalElement external : this.externalPayloads) {
            xml.append((Element)external);
        }
        for (ExtensionElement wrapped : this.wrappedPayloads) {
            xml.append((Element)wrapped);
        }
    }

    public static FasteningElement createShellElementForSensitiveElement(FasteningElement sensitiveElement) {
        return FasteningElement.createShellElementForSensitiveElement(sensitiveElement.getReferencedStanzasOriginId());
    }

    public static FasteningElement createShellElementForSensitiveElement(String originIdOfSensitiveElement) {
        return FasteningElement.createShellElementForSensitiveElement(new OriginIdElement(originIdOfSensitiveElement));
    }

    public static FasteningElement createShellElementForSensitiveElement(OriginIdElement originIdOfSensitiveElement) {
        return FasteningElement.builder().setOriginId(originIdOfSensitiveElement).setShell().build();
    }

    public void applyTo(MessageBuilder messageBuilder) {
        if (FasteningElement.hasFasteningElement(messageBuilder)) {
            throw new IllegalArgumentException("Stanza cannot contain more than one apply-to elements.");
        }
        messageBuilder.addExtension((ExtensionElement)this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private OriginIdElement originId;
        private final List<ExtensionElement> wrappedPayloads = new ArrayList<ExtensionElement>();
        private final List<ExternalElement> externalPayloads = new ArrayList<ExternalElement>();
        private boolean isClear = false;
        private boolean isShell = false;

        public Builder setOriginId(String originIdString) {
            return this.setOriginId(new OriginIdElement(originIdString));
        }

        public Builder setOriginId(OriginIdElement originId) {
            this.originId = originId;
            return this;
        }

        public Builder addWrappedPayload(ExtensionElement wrappedPayload) {
            return this.addWrappedPayloads(Collections.singletonList(wrappedPayload));
        }

        public Builder addWrappedPayloads(List<ExtensionElement> wrappedPayloads) {
            this.wrappedPayloads.addAll(wrappedPayloads);
            return this;
        }

        public Builder addExternalPayload(ExternalElement externalPayload) {
            return this.addExternalPayloads(Collections.singletonList(externalPayload));
        }

        public Builder addExternalPayloads(List<ExternalElement> externalPayloads) {
            this.externalPayloads.addAll(externalPayloads);
            return this;
        }

        public Builder setClear() {
            this.isClear = true;
            return this;
        }

        public Builder setShell() {
            this.isShell = true;
            return this;
        }

        public FasteningElement build() {
            this.validateThatIfIsShellThenOtherwiseEmpty();
            return new FasteningElement(this.originId, this.wrappedPayloads, this.externalPayloads, this.isClear, this.isShell);
        }

        private void validateThatIfIsShellThenOtherwiseEmpty() {
            if (!this.isShell) {
                return;
            }
            if (this.isClear || !this.wrappedPayloads.isEmpty() || !this.externalPayloads.isEmpty()) {
                throw new IllegalArgumentException("A fastening that is a shell element must be otherwise empty and cannot have a 'clear' attribute.");
            }
        }
    }
}

