/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle_filetransfer.provider;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.hashes.element.HashElement;
import org.jivesoftware.smackx.hashes.provider.HashElementProvider;
import org.jivesoftware.smackx.jingle.element.JingleContentDescriptionChildElement;
import org.jivesoftware.smackx.jingle.provider.JingleContentDescriptionProvider;
import org.jivesoftware.smackx.jingle_filetransfer.element.JingleFileTransfer;
import org.jivesoftware.smackx.jingle_filetransfer.element.JingleFileTransferChild;
import org.jivesoftware.smackx.jingle_filetransfer.element.Range;
import org.jxmpp.util.XmppDateTime;

public class JingleFileTransferProvider
extends JingleContentDescriptionProvider<JingleFileTransfer> {
    public JingleFileTransfer parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        ArrayList<JingleContentDescriptionChildElement> payloads = new ArrayList<JingleContentDescriptionChildElement>();
        JingleFileTransferChild.Builder builder = JingleFileTransferChild.getBuilder();
        while (true) {
            XmlPullParser.TagEvent tag = parser.nextTag();
            block1 : switch (tag) {
                case START_ELEMENT: {
                    String elementName;
                    switch (elementName = parser.getName()) {
                        case "date": {
                            try {
                                builder.setDate(XmppDateTime.parseXEP0082Date((String)parser.nextText()));
                                break block1;
                            }
                            catch (ParseException e) {
                                throw new SmackParsingException.SmackTextParseException(e);
                            }
                        }
                        case "desc": {
                            builder.setDescription(parser.nextText());
                            break block1;
                        }
                        case "media-type": {
                            builder.setMediaType(parser.nextText());
                            break block1;
                        }
                        case "name": {
                            builder.setName(parser.nextText());
                            break block1;
                        }
                        case "size": {
                            builder.setSize(Integer.parseInt(parser.nextText()));
                            break block1;
                        }
                        case "range": {
                            Range range = JingleFileTransferProvider.parseRangeElement(parser);
                            builder.setRange(range);
                            break block1;
                        }
                        case "hash": {
                            HashElement hashElement = (HashElement)HashElementProvider.INSTANCE.parse(parser);
                            builder.setHash(hashElement);
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    String elementName;
                    switch (elementName = parser.getName()) {
                        case "file": {
                            payloads.add(builder.build());
                            builder = JingleFileTransferChild.getBuilder();
                            break block1;
                        }
                        case "description": {
                            return new JingleFileTransfer(payloads);
                        }
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Range parseRangeElement(XmlPullParser parser) throws IOException, XmlPullParserException, SmackParsingException {
        int initialDepth = parser.getDepth();
        Integer offset = ParserUtils.getIntegerAttribute((XmlPullParser)parser, (String)"offset");
        Integer length = ParserUtils.getIntegerAttribute((XmlPullParser)parser, (String)"length");
        HashElement hashElement = null;
        while (true) {
            XmlPullParser.Event event = parser.next();
            block0 : switch (event) {
                case START_ELEMENT: {
                    String element;
                    switch (element = parser.getName()) {
                        case "hash": {
                            hashElement = (HashElement)HashElementProvider.INSTANCE.parse(parser);
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    String element = parser.getName();
                    if (!element.equals("range") || parser.getDepth() != initialDepth) break;
                    return new Range(offset, length, hashElement);
                }
            }
        }
    }
}

