/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle_filetransfer.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.hashes.element.HashElement;
import org.jivesoftware.smackx.hashes.provider.HashElementProvider;
import org.jivesoftware.smackx.jingle.element.JingleContent;
import org.jivesoftware.smackx.jingle_filetransfer.element.Checksum;
import org.jivesoftware.smackx.jingle_filetransfer.element.JingleFileTransferChild;
import org.jivesoftware.smackx.jingle_filetransfer.element.Range;

public class ChecksumProvider
extends ExtensionElementProvider<Checksum> {
    /*
     * Enabled aggressive block sorting
     */
    public Checksum parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        JingleContent.Creator creator = null;
        String creatorString = parser.getAttributeValue(null, "creator");
        if (creatorString != null) {
            creator = JingleContent.Creator.valueOf((String)creatorString);
        }
        String name = parser.getAttributeValue(null, "name");
        JingleFileTransferChild.Builder cb = JingleFileTransferChild.getBuilder();
        HashElement hashElement = null;
        Range range = null;
        boolean go = true;
        block20: while (go) {
            XmlPullParser.TagEvent tag = parser.nextTag();
            String n = parser.getText();
            block0 : switch (tag) {
                case START_ELEMENT: {
                    switch (n) {
                        case "hash": {
                            hashElement = (HashElement)new HashElementProvider().parse(parser);
                            break block0;
                        }
                        case "range": {
                            String offset = parser.getAttributeValue(null, "offset");
                            String length = parser.getAttributeValue(null, "length");
                            int o = offset == null ? 0 : Integer.parseInt(offset);
                            int l = length == null ? -1 : Integer.parseInt(length);
                            range = new Range(o, l);
                            continue block20;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    switch (n) {
                        case "range": {
                            if (hashElement == null || range == null) break;
                            range = new Range(range.getOffset(), range.getLength(), hashElement);
                            hashElement = null;
                            break;
                        }
                        case "file": {
                            if (hashElement != null) {
                                cb.setHash(hashElement);
                            }
                            if (range != null) {
                                cb.setRange(range);
                            }
                            go = false;
                        }
                    }
                    continue block20;
                }
            }
        }
        return new Checksum(creator, name, cb.build());
    }
}

