/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.httpfileupload;

import org.jivesoftware.smack.util.Objects;
import org.jxmpp.jid.DomainBareJid;

public class UploadService {
    private final DomainBareJid address;
    private final Version version;
    private final Long maxFileSize;

    UploadService(DomainBareJid address, Version version) {
        this(address, version, null);
    }

    UploadService(DomainBareJid address, Version version, Long maxFileSize) {
        this.address = (DomainBareJid)Objects.requireNonNull((Object)address);
        this.version = version;
        this.maxFileSize = maxFileSize;
    }

    public DomainBareJid getAddress() {
        return this.address;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean hasMaxFileSizeLimit() {
        return this.maxFileSize != null;
    }

    public Long getMaxFileSize() {
        return this.maxFileSize;
    }

    public boolean acceptsFileOfSize(long size) {
        if (!this.hasMaxFileSizeLimit()) {
            return true;
        }
        return size <= this.maxFileSize;
    }

    public static enum Version {
        v0_2,
        v0_3;

    }
}

