/**
 *
 * Copyright 2019 Florian Schmaus
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jivesoftware.smackx.jid_prep.element;

import org.jivesoftware.smack.packet.IQ;

public class JidPrepIq extends IQ {

    public static final String ELEMENT = "jid";
    public static final String NAMESPACE = "urn:xmpp:jidprep:0";

    private final String jid;

    public JidPrepIq(String jid) {
        super(ELEMENT, NAMESPACE);
        this.jid = jid;
    }

    public String getJid() {
        return jid;
    }

    @Override
    protected IQChildElementXmlStringBuilder getIQChildElementBuilder(IQChildElementXmlStringBuilder xml) {
        xml.rightAngleBracket();
        xml.escape(jid);

        return xml;
    }
}
