/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util.cert;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jivesoftware.util.cert.CertificateIdentityMapping;

public class CNCertificateIdentityMapping
implements CertificateIdentityMapping {
    private static Pattern cnPattern = Pattern.compile("(?i)(cn=)([^,]*)");

    @Override
    public List<String> mapIdentity(X509Certificate certificate) {
        String name = certificate.getSubjectDN().getName();
        Matcher matcher = cnPattern.matcher(name);
        ArrayList<String> names = new ArrayList<String>();
        while (matcher.find()) {
            names.add(matcher.group(2));
        }
        return names;
    }

    @Override
    public String name() {
        return "Common Name Mapping";
    }
}

